/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.gui.guiContainer;

import com.xiaoxianben.watergenerators.gui.container.ContainerMa;
import com.xiaoxianben.watergenerators.gui.guiContainer.GuiEnergyBase;
import com.xiaoxianben.watergenerators.math.PrivateMath;
import com.xiaoxianben.watergenerators.tileEntity.generator.TEGeneratorBase;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiGeneratorBasic
extends GuiEnergyBase {
    private final TEGeneratorBase teGeneratorBase;
    protected final List<String> drawStringList = new ArrayList<String>();
    protected final int textStartX;
    protected final int textStartY;
    protected final int textWidth;
    protected int guiId = 0;

    public GuiGeneratorBasic(ContainerMa inventorySlotsIn, int ID, int textStartX, int textStartY, int textWidth) {
        super(inventorySlotsIn, ID);
        this.teGeneratorBase = (TEGeneratorBase)this.tileEntity;
        this.textStartX = textStartX;
        this.textStartY = textStartY;
        this.textWidth = textWidth;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b(new Button(0, this.field_147003_i + this.field_146999_f + 1, this.field_147009_r + 1, new ResourceLocation("watergenerators", "textures/items/information_finder.png"), 16, 16));
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.guiId = 1 + -1 * this.guiId;
        }
    }

    @Override
    protected void drawAllGUIText() {
        int textStartXTemp = this.textStartX;
        int textStartYTemp = this.textStartY;
        int textWidthTemp = this.textWidth;
        switch (this.guiId) {
            case 0: {
                this.updateDefaultStringList();
                break;
            }
            case 1: {
                this.updateInforGuiStringList();
                textStartXTemp = 4;
                textStartYTemp = 12;
                textWidthTemp = 166;
            }
        }
        int XString = this.field_147003_i + textStartXTemp;
        StringBuilder s = new StringBuilder();
        for (String string : this.drawStringList) {
            s.append(string).append("\n");
        }
        s.delete(s.length() - 1, s.length());
        this.field_146289_q.func_78279_b(s.toString(), XString, this.field_147009_r + textStartYTemp, textWidthTemp, 0);
    }

    @Override
    public List<Rectangle> getGuiExtraAreas() {
        List<Rectangle> rectangles = super.getGuiExtraAreas();
        for (GuiButton button : this.field_146292_n) {
            rectangles.add(new Rectangle(button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g));
        }
        return rectangles;
    }

    @Override
    protected void drawAllMouseRect(int mouseX, int mouseY) {
        if (this.guiId == 0) {
            this.drawDefaultMouseRect(mouseX, mouseY);
        }
    }

    @Override
    protected void drawAllGUITextures() {
        if (this.guiId == 0) {
            this.drawDefaultGUITextures();
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("watergenerators", "textures/gui/0.png"));
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        }
    }

    protected void drawDefaultGUITextures() {
        super.drawAllGUITextures();
    }

    protected void drawDefaultMouseRect(int mouseX, int mouseY) {
        super.drawAllMouseRect(mouseX, mouseY);
    }

    protected void updateDefaultStringList() {
        this.drawStringList.clear();
        this.drawStringList.add(I18n.func_135052_a((String)"gui.basePowerGeneration.text", (Object[])new Object[]{PrivateMath.getRoughData(this.teGeneratorBase.basePowerGeneration)}));
        this.drawStringList.add(I18n.func_135052_a((String)"gui.energyIncreaseDecrease.text", (Object[])new Object[]{PrivateMath.getRoughData(this.teGeneratorBase.getFinallyReceiveEnergy()), PrivateMath.getRoughData(this.teGeneratorBase.getFinallyExtractEnergy())}));
    }

    protected void updateInforGuiStringList() {
        this.updateDefaultStringList();
    }

    @SideOnly(value=Side.CLIENT)
    static class Button
    extends GuiButton {
        private final ResourceLocation iconTexture;
        private final int iconWidth;
        private final int iconHeight;

        protected Button(int buttonId, int x, int y, ResourceLocation iconTextureIn, int iconWidth, int iconHeight) {
            super(buttonId, x, y, 22, 22, "");
            this.iconTexture = iconTextureIn;
            this.iconWidth = iconWidth;
            this.iconHeight = iconHeight;
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/container/beacon.png"));
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int j = 0;
                if (!this.field_146124_l) {
                    j += this.field_146120_f * 2;
                } else if (this.field_146123_n) {
                    j += this.field_146120_f * 3;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, j, 219, this.field_146120_f, this.field_146121_g);
                mc.func_110434_K().func_110577_a(this.iconTexture);
                Button.func_146110_a((int)(this.field_146128_h + (this.field_146120_f - this.iconWidth) / 2), (int)(this.field_146129_i + (this.field_146121_g - this.iconHeight) / 2), (float)0.0f, (float)0.0f, (int)this.iconWidth, (int)this.iconHeight, (float)this.iconWidth, (float)this.iconHeight);
            }
        }
    }
}

