/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.init;

import com.xiaoxianben.watergenerators.blocks.generator.BlockGeneratorBasic;
import com.xiaoxianben.watergenerators.blocks.generator.BlockGeneratorFluid;
import com.xiaoxianben.watergenerators.blocks.machine.BlockMachineBase;
import com.xiaoxianben.watergenerators.blocks.machine.BlockMachineShell;
import com.xiaoxianben.watergenerators.init.EnumModBlock;
import com.xiaoxianben.watergenerators.init.EnumModItems;
import com.xiaoxianben.watergenerators.init.modRegister.EnumModRegister;
import com.xiaoxianben.watergenerators.items.component.ItemComponent;
import com.xiaoxianben.watergenerators.jsonRecipe.ModJsonRecipe;
import com.xiaoxianben.watergenerators.jsonRecipe.crafting.ShapedRecipes;
import com.xiaoxianben.watergenerators.jsonRecipe.crafting.ShapelessRecipes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModRecipes {
    public static ModRecipes instance;
    public final HashMap<String, ItemStack> mapFluidMaterial = new HashMap();
    public final String[] nameType = new String[]{"turbine", "fluid"};
    public ItemStack[] inputItemStack;
    public HashMap<String, Integer> recipeIdMap = new HashMap();

    private void addShapedRecipe(ResourceLocation name, ResourceLocation group, int index, @Nonnull ItemStack output, Object ... params) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])params);
        ShapedRecipes value = new ShapedRecipes(group == null ? "" : group.toString(), primer.width, primer.height, (NonNullList<Ingredient>)primer.input, output, index);
        value.setRegistryName(name);
        GameData.register_impl((IForgeRegistryEntry)value);
    }

    private void addShapelessRecipe(ResourceLocation name, ResourceLocation group, @Nonnull ItemStack output, Ingredient ... params) {
        NonNullList lst = NonNullList.func_191196_a();
        lst.addAll(Arrays.asList(params));
        ShapelessRecipes value = new ShapelessRecipes(group == null ? "" : group.toString(), output, (NonNullList<Ingredient>)lst);
        value.setRegistryName(name);
        GameData.register_impl((IForgeRegistryEntry)value);
    }

    @ParametersAreNonnullByDefault
    public void addRecipeBlock(Item output, Item ingot) {
        Object[] params = new Object[]{"III", "III", "III", Character.valueOf('I'), ingot};
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(Objects.requireNonNull(output.getRegistryName()).toString() + '1'), (ResourceLocation)new ResourceLocation("watergenerators", "block"), (ItemStack)output.func_190903_i(), (Object[])params);
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(Objects.requireNonNull(ingot.getRegistryName()).toString() + '1'), (ResourceLocation)new ResourceLocation("watergenerators", "ingot"), (ItemStack)new ItemStack(ingot, 9), (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)output)});
    }

    public void addRecipeShell(@Nonnull Block output, @Nullable Block block, @Nullable String oreIngot) {
        Object[] params = new Object[]{"OLO", "LIL", "OLO", Character.valueOf('O'), "ingotIron", Character.valueOf('I'), block == null ? "ingotIron" : block, Character.valueOf('L'), oreIngot == null ? Items.field_190931_a : oreIngot};
        GameRegistry.addShapedRecipe((ResourceLocation)output.getRegistryName(), (ResourceLocation)new ResourceLocation("watergenerators", "shell"), (ItemStack)Item.func_150898_a((Block)output).func_190903_i(), (Object[])params);
    }

    public void addRecipeGear(@Nonnull Item output, String materialOreName) {
        Object[] params = new Object[]{" O ", "OGO", " O ", Character.valueOf('O'), materialOreName, Character.valueOf('G'), "ingotIron"};
        GameRegistry.addShapedRecipe((ResourceLocation)output.getRegistryName(), (ResourceLocation)new ResourceLocation("watergenerators", "gears"), (ItemStack)output.func_190903_i(), (Object[])params);
    }

    public void addRecipeTurbineRotor(@Nonnull Item output, String inputOre, String gearOre) {
        Object[] params = new Object[]{"OOO", "OGO", "OOO", Character.valueOf('O'), inputOre, Character.valueOf('G'), gearOre};
        GameRegistry.addShapedRecipe((ResourceLocation)output.getRegistryName(), (ResourceLocation)new ResourceLocation("watergenerators", "turbineRotor"), (ItemStack)output.func_190903_i(), (Object[])params);
    }

    public void addRecipeCoil(@Nonnull Item output, Item materialItem, String materialOreName) {
        Object[] params = new Object[]{"OOO", "RCR", "OOO", Character.valueOf('O'), materialOreName, Character.valueOf('C'), materialItem == null ? materialOreName : materialItem, Character.valueOf('R'), "dustRedstone"};
        GameRegistry.addShapedRecipe((ResourceLocation)output.getRegistryName(), (ResourceLocation)new ResourceLocation("watergenerators", "coil"), (ItemStack)output.func_190903_i(), (Object[])params);
    }

    public void addRecipeConduit(@Nonnull Item output, Item coil, Item oldItem) {
        Object[] params = new Object[]{"BBB", "CDC", "BBB", Character.valueOf('C'), coil, Character.valueOf('D'), oldItem, Character.valueOf('B'), "itemConduitBinder"};
        GameRegistry.addShapedRecipe((ResourceLocation)output.getRegistryName(), (ResourceLocation)new ResourceLocation("watergenerators", "duct_coil"), (ItemStack)output.func_190903_i(), (Object[])params);
    }

    public void addRecipeGenerator(BlockGeneratorBasic output, ItemStack conduit, Item turbineRotor, BlockMachineShell blockMachineShell, Block oldGenerator, String gearOreName) {
        this.addRecipeGenerator(output, conduit, turbineRotor, blockMachineShell, oldGenerator == null ? null : Item.func_150898_a((Block)oldGenerator).func_190903_i(), gearOreName);
    }

    public void addRecipeGenerator(BlockGeneratorBasic output, ItemStack conduit, Item turbineRotor, BlockMachineShell blockMachineShell, ItemStack oldGenerator, String gearOreName) {
        ItemStack materialItem;
        String[] nameStr = Objects.requireNonNull(output.getRegistryName()).func_110623_a().split("_");
        if (Arrays.stream(this.nameType).anyMatch(s -> Objects.equals(s, nameStr[0]))) {
            this.addGeneratorRecipe(output, this.inputItemStack[Arrays.stream(this.nameType).collect(Collectors.toList()).indexOf(nameStr[0])], nameStr[2], (String[])Arrays.stream((Object[])this.nameType.clone()).filter(s -> !Objects.equals(s, nameStr[0])).toArray(String[]::new));
        }
        if (output instanceof BlockGeneratorFluid && (materialItem = this.mapFluidMaterial.get(nameStr[0])) != null) {
            BlockGeneratorFluid inBlock = Objects.requireNonNull((BlockGeneratorFluid)Block.func_149684_b((String)("watergenerators:fluid_generator_" + nameStr[2])));
            this.addShapelessRecipe(new ResourceLocation("watergenerators", this.getRecipeGeneratorPath(inBlock)), new ResourceLocation("watergenerators", "generator_downgrade"), Item.func_150898_a((Block)inBlock).func_190903_i(), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)output)), Ingredient.func_193367_a((Item)Items.field_151145_ak));
            if (nameStr[2].equals("level1")) {
                this.addGeneratorFluid(output, inBlock, materialItem);
                return;
            }
            this.addGeneratorFluid(output, inBlock, materialItem, 1);
        }
        Object[] params = new Object[]{"FZF", "DCD", "FGF", Character.valueOf('F'), blockMachineShell, Character.valueOf('D'), conduit, Character.valueOf('Z'), turbineRotor, Character.valueOf('G'), gearOreName, Character.valueOf('C'), oldGenerator == null ? this.inputItemStack[Arrays.stream(this.nameType).collect(Collectors.toList()).indexOf(nameStr[0])] : oldGenerator};
        this.addShapedRecipe(output.getRegistryName(), null, 4, Item.func_150898_a((Block)output).func_190903_i(), params);
    }

    private void addGeneratorFluid(BlockGeneratorBasic output, BlockGeneratorFluid inBlock, ItemStack otherFluidItem) {
        this.addGeneratorFluid(output, inBlock, otherFluidItem, 0);
    }

    private void addGeneratorFluid(BlockGeneratorBasic output, BlockGeneratorFluid inBlock, ItemStack otherFluidItem, int id) {
        Object[] params = new Object[]{"FZF", "DCD", "FGF", Character.valueOf('F'), EnumModBlock.MACHINE_SHELL.blockMap.get((Object)EnumModRegister.MINECRAFT)[0], Character.valueOf('D'), EnumModItems.CONDUIT.itemMap.get((Object)EnumModRegister.MINECRAFT)[0], Character.valueOf('Z'), EnumModItems.TURBINE_ROTOR.itemMap.get((Object)EnumModRegister.MINECRAFT)[0], Character.valueOf('G'), otherFluidItem, Character.valueOf('C'), inBlock};
        this.addShapedRecipe(new ResourceLocation("watergenerators", id == 0 ? output.getRegistryName().func_110623_a() : this.getRecipeGeneratorPath(output)), new ResourceLocation("watergenerators", "generator_fluid"), 4, Item.func_150898_a((Block)output).func_190903_i(), params);
    }

    private void addGeneratorRecipe(Block output, ItemStack fuelItem, String name, String[] nameStr) {
        Item generator = Item.func_150898_a((Block)output);
        Item[] otherGenerators = new Item[nameStr.length];
        for (int i = 0; i < otherGenerators.length; ++i) {
            otherGenerators[i] = Item.func_111206_d((String)("watergenerators:" + nameStr[i] + "_generator_" + name));
        }
        for (Item otherGenerator : otherGenerators) {
            this.addShapelessRecipe(new ResourceLocation("watergenerators", this.getRecipeGeneratorPath(output)), new ResourceLocation("watergenerators", "generator_transformation"), generator.func_190903_i(), Ingredient.func_193367_a((Item)otherGenerator), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{fuelItem}));
        }
    }

    private String getRecipeGeneratorPath(Block block) {
        int i = this.getRecipeGeneratorId(Objects.requireNonNull(block.getRegistryName()).toString());
        return block.getRegistryName().func_110623_a() + "_" + i;
    }

    private int getRecipeGeneratorId(String recipeName) {
        Integer i = this.recipeIdMap.get(recipeName);
        if (i == null) {
            this.recipeIdMap.put(recipeName, 1);
            i = 0;
        } else {
            this.recipeIdMap.put(recipeName, i + 1);
        }
        return i;
    }

    public void addRecipeMachineVaporization(BlockMachineBase output, BlockMachineShell machineShell, ItemStack conduit, String gearOre) {
        Object[] params = new Object[]{"FCF", "DGD", "FCF", Character.valueOf('F'), machineShell, Character.valueOf('D'), Items.field_151133_ar, Character.valueOf('C'), conduit, Character.valueOf('G'), gearOre};
        GameRegistry.addShapedRecipe((ResourceLocation)output.getRegistryName(), (ResourceLocation)new ResourceLocation("watergenerators", "machine"), (ItemStack)Item.func_150898_a((Block)output).func_190903_i(), (Object[])params);
    }

    public void addRecipeMachineConcentration(BlockMachineBase output, BlockMachineShell machineShell, ItemStack conduit, BlockMachineBase inMachine) {
        Object[] params = new Object[]{"FCF", "DGD", "FCF", Character.valueOf('F'), machineShell, Character.valueOf('D'), Items.field_151133_ar, Character.valueOf('C'), conduit, Character.valueOf('G'), inMachine};
        GameRegistry.addShapedRecipe((ResourceLocation)output.getRegistryName(), (ResourceLocation)new ResourceLocation("watergenerators", "machine"), (ItemStack)Item.func_150898_a((Block)output).func_190903_i(), (Object[])params);
    }

    public void addRecipeComponent(ItemComponent component, Item oldItem, Item recipeItem) {
        Object[] params = new Object[]{"GGG", "ROR", "GGG", Character.valueOf('G'), "ingotGoldPlatedIron", Character.valueOf('R'), recipeItem != null ? recipeItem : "ingotGoldPlatedIron", Character.valueOf('O'), oldItem};
        GameRegistry.addShapedRecipe((ResourceLocation)component.getRegistryName(), (ResourceLocation)new ResourceLocation("watergenerators", "component"), (ItemStack)component.func_190903_i(), (Object[])params);
    }

    public void init() {
        new ModJsonRecipe().init();
        this.recipeIdMap = null;
    }
}

