/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.init.modRegister;

import com.xiaoxianben.watergenerators.config.ConfigLoader;
import com.xiaoxianben.watergenerators.init.modRegister.EnderIORegister;
import com.xiaoxianben.watergenerators.init.modRegister.IModRegister;
import com.xiaoxianben.watergenerators.init.modRegister.MekanismRegister;
import com.xiaoxianben.watergenerators.init.modRegister.MinecraftRegister;
import com.xiaoxianben.watergenerators.init.modRegister.TFRegister;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;

public enum EnumModRegister {
    MINECRAFT("minecraft", MinecraftRegister.class),
    TF("thermalfoundation;thermaldynamics", TFRegister.class),
    EnderIO("enderio", EnderIORegister.class),
    MEKANISM("mekanism", MekanismRegister.class);

    private final String[] modIds;
    private boolean isEnable = false;
    private Object register;

    private EnumModRegister(String modId, Class<? extends IModRegister> register) {
        this.modIds = modId.split(";");
        this.register = register;
    }

    public void enable() {
        ArrayList<Boolean> b = new ArrayList<Boolean>();
        for (String modId : this.modIds) {
            b.add(Loader.isModLoaded((String)modId));
        }
        boolean bl = this.isEnable = !b.contains(false);
        if (this.isEnable) {
            ConfigLoader.logger().info("the {} extension is loading.", (Object)this.modIds[0]);
            if (this.register instanceof Class) {
                try {
                    this.register = ((Class)this.register).newInstance();
                }
                catch (Exception e) {
                    ConfigLoader.logger().error("the {} extension is not loaded.", (Object)this.modIds[0]);
                }
            }
        }
    }

    private boolean isEnable() {
        return this.isEnable;
    }

    @Nullable
    public IModRegister getRegister() {
        try {
            return this.isEnable ? (IModRegister)this.register : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void preInit() {
        IModRegister register1 = this.getRegister();
        if (register1 != null) {
            register1.preInit();
        }
    }

    public void init() {
        IModRegister register1 = this.getRegister();
        if (register1 != null) {
            register1.init();
        }
    }

    public void posInit() {
        IModRegister register1 = this.getRegister();
        if (register1 != null) {
            register1.posInit();
            ConfigLoader.logger().info("the {} extension is loaded.", (Object)this.modIds[0]);
        }
        this.register = null;
    }
}

