/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.jei;

import com.xiaoxianben.watergenerators.config.ConfigValue;
import com.xiaoxianben.watergenerators.gui.guiContainer.GuiGeneratorFluid;
import com.xiaoxianben.watergenerators.gui.guiContainer.GuiMachineConcentration;
import com.xiaoxianben.watergenerators.gui.guiContainer.GuiMachineVa;
import com.xiaoxianben.watergenerators.init.EnumModBlock;
import com.xiaoxianben.watergenerators.jei.advancedGuiHandlers.GeneratorAdvancedGuiHandlers;
import com.xiaoxianben.watergenerators.jei.recipeCategory.ConcentrationRecipeCategory;
import com.xiaoxianben.watergenerators.jei.recipeCategory.DedicatedFluidRecipeCategory;
import com.xiaoxianben.watergenerators.jei.recipeCategory.FluidRecipeCategory;
import com.xiaoxianben.watergenerators.jei.recipeCategory.VaporizationRecipeCategory;
import com.xiaoxianben.watergenerators.jei.wrapper.FluidGeneratorWrapper;
import com.xiaoxianben.watergenerators.jei.wrapper.FluidToFluidWrapper;
import com.xiaoxianben.watergenerators.jsonRecipe.ModJsonRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

@JEIPlugin
public class modPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new VaporizationRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ConcentrationRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidRecipeCategory(guiHelper)});
        for (int i = 0; i < ModJsonRecipe.recipeFluidGenerator.size(); ++i) {
            Fluid input = ModJsonRecipe.recipeFluidGenerator.getInput(i);
            registry.addRecipeCategories(new IRecipeCategory[]{new DedicatedFluidRecipeCategory(input.getName(), guiHelper)});
        }
    }

    public void register(@Nonnull IModRegistry registration) {
        for (Block[] vaporization : EnumModBlock.MACHINE_VAPORIZATION.blockMap.values()) {
            for (Block block : vaporization) {
                if (block == null || Item.func_150898_a((Block)block).func_190903_i().func_190926_b()) continue;
                registration.addRecipeCatalyst((Object)Item.func_150898_a((Block)block).func_190903_i(), new String[]{"watergenerators:vaporization"});
            }
        }
        for (Block[] vaporization : EnumModBlock.MACHINE_CONCENTRATION.blockMap.values()) {
            for (Block block : vaporization) {
                if (block == null || Item.func_150898_a((Block)block).func_190903_i().func_190926_b()) continue;
                registration.addRecipeCatalyst((Object)Item.func_150898_a((Block)block).func_190903_i(), new String[]{"watergenerators:concentration"});
            }
        }
        for (Block[] value : EnumModBlock.GENERATOR_fluid.blockMap.values()) {
            for (Block block : value) {
                if (block == null || Item.func_150898_a((Block)block).func_190903_i().func_190926_b()) continue;
                registration.addRecipeCatalyst((Object)Item.func_150898_a((Block)block).func_190903_i(), new String[]{"watergenerators:fluidGenerator"});
            }
        }
        for (Block[] value : EnumModBlock.GENERATOR_water.blockMap.values()) {
            for (Block block : value) {
                if (block == null || Item.func_150898_a((Block)block).func_190903_i().func_190926_b()) continue;
                registration.addRecipeCatalyst((Object)Item.func_150898_a((Block)block).func_190903_i(), new String[]{DedicatedFluidRecipeCategory.getFluidUid("water")});
            }
        }
        for (Block[] value : EnumModBlock.GENERATOR_waterCompressed.blockMap.values()) {
            for (Block block : value) {
                if (block == null || Item.func_150898_a((Block)block).func_190903_i().func_190926_b()) continue;
                registration.addRecipeCatalyst((Object)Item.func_150898_a((Block)block).func_190903_i(), new String[]{DedicatedFluidRecipeCategory.getFluidUid("watercompressed")});
            }
        }
        for (Block[] value : EnumModBlock.GENERATOR_steam.blockMap.values()) {
            for (Block block : value) {
                if (block == null || Item.func_150898_a((Block)block).func_190903_i().func_190926_b()) continue;
                registration.addRecipeCatalyst((Object)Item.func_150898_a((Block)block).func_190903_i(), new String[]{DedicatedFluidRecipeCategory.getFluidUid("steam")});
            }
        }
        registration.addRecipes(this.vaporizationRecipes(), "watergenerators:vaporization");
        registration.addRecipes(this.concentrationRecipes(), "watergenerators:concentration");
        registration.addRecipes(this.FluidGeneratorRecipes(), "watergenerators:fluidGenerator");
        for (int i = 0; i < ModJsonRecipe.recipeFluidGenerator.size(); ++i) {
            Fluid fluid = ModJsonRecipe.recipeFluidGenerator.getInput(i);
            FluidStack input = new FluidStack(fluid, ConfigValue.basicAmountOfFluidToProduceEnergy);
            registration.addRecipes(Collections.singleton(new FluidGeneratorWrapper(input)), DedicatedFluidRecipeCategory.getFluidUid(fluid.getName()));
        }
        registration.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new GeneratorAdvancedGuiHandlers()});
        registration.addRecipeClickArea(GuiMachineConcentration.class, 70, 28, 36, 17, new String[]{"watergenerators:concentration"});
        registration.addRecipeClickArea(GuiMachineVa.class, 70, 28, 36, 17, new String[]{"watergenerators:vaporization"});
        String[] UIDS = new String[ModJsonRecipe.recipeFluidGenerator.size() + 1];
        UIDS[0] = "watergenerators:fluidGenerator";
        for (int i = 1; i <= ModJsonRecipe.recipeFluidGenerator.size(); ++i) {
            Fluid fluid = ModJsonRecipe.recipeFluidGenerator.getInput(i);
            UIDS[i] = DedicatedFluidRecipeCategory.getFluidUid(fluid.getName());
        }
        registration.addRecipeClickArea(GuiGeneratorFluid.class, 40, 33, 20, 20, UIDS);
    }

    private List<FluidToFluidWrapper> vaporizationRecipes() {
        ArrayList<FluidToFluidWrapper> recipes = new ArrayList<FluidToFluidWrapper>();
        for (int i = 0; i < ModJsonRecipe.recipeVaporization.size(); ++i) {
            FluidStack input = ModJsonRecipe.recipeVaporization.getInput(i);
            FluidStack Output = ModJsonRecipe.recipeVaporization.getOutput(i).getFluidStack1();
            recipes.add(new FluidToFluidWrapper(input, Output));
        }
        return recipes;
    }

    private List<FluidToFluidWrapper> concentrationRecipes() {
        ArrayList<FluidToFluidWrapper> recipes = new ArrayList<FluidToFluidWrapper>();
        for (int i = 0; i < ModJsonRecipe.recipeConcentration.size(); ++i) {
            FluidStack input = ModJsonRecipe.recipeConcentration.getInput(i);
            FluidStack Output = ModJsonRecipe.recipeConcentration.getOutput(i).getFluidStack1();
            recipes.add(new FluidToFluidWrapper(input, Output));
        }
        return recipes;
    }

    private List<FluidGeneratorWrapper> FluidGeneratorRecipes() {
        ArrayList<FluidGeneratorWrapper> recipes = new ArrayList<FluidGeneratorWrapper>();
        for (int i = 0; i < ModJsonRecipe.recipeFluidGenerator.size(); ++i) {
            FluidStack input = new FluidStack(ModJsonRecipe.recipeFluidGenerator.getInput(i), ConfigValue.basicAmountOfFluidToProduceEnergy);
            recipes.add(new FluidGeneratorWrapper(input));
        }
        return recipes;
    }
}

