/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.jsonRecipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xiaoxianben.watergenerators.config.ConfigLoader;
import com.xiaoxianben.watergenerators.jsonRecipe.Recipes;
import com.xiaoxianben.watergenerators.jsonRecipe.ingredients.FluidStackAndEnergy;
import com.xiaoxianben.watergenerators.jsonRecipe.recipeType.RecipeTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ModJsonRecipe {
    public static Recipes<FluidStack, FluidStackAndEnergy> recipeVaporization = new Recipes<FluidStack, FluidStackAndEnergy>(RecipeTypes.recipe_fluidStack, RecipeTypes.recipe_fluidStackAndEnergy);
    public static Recipes<FluidStack, FluidStackAndEnergy> recipeConcentration = new Recipes<FluidStack, FluidStackAndEnergy>(RecipeTypes.recipe_fluidStack, RecipeTypes.recipe_fluidStackAndEnergy);
    public static Recipes<Fluid, Float> recipeFluidGenerator = new Recipes<Fluid, Float>(RecipeTypes.recipe_fluid, RecipeTypes.recipe_float);

    public void init() {
        recipeVaporization.addRecipe(new FluidStack(FluidRegistry.WATER, 1), new FluidStackAndEnergy(new FluidStack(FluidRegistry.getFluid((String)"steam"), 1), -1));
        recipeConcentration.addRecipe(new FluidStack(FluidRegistry.WATER, 100), new FluidStackAndEnergy(new FluidStack(FluidRegistry.getFluid((String)"watercompressed"), 1), -1000));
        recipeFluidGenerator.addRecipe(FluidRegistry.WATER, Float.valueOf(1.0f));
        recipeFluidGenerator.addRecipe(FluidRegistry.getFluid((String)"watercompressed"), Float.valueOf(8.0f));
        recipeFluidGenerator.addRecipe(FluidRegistry.getFluid((String)"steam"), Float.valueOf(2.0f));
        String recipeDir = ConfigLoader.WGConfigDirectory + "/recipe";
        recipeVaporization = this.readJson(recipeDir + "/vaporization.json", recipeVaporization);
        recipeFluidGenerator = this.readJson(recipeDir + "/fluidGenerator.json", recipeFluidGenerator);
        recipeConcentration = this.readJson(recipeDir + "/recipeConcentration.json", recipeConcentration);
    }

    @Nonnull
    public <Input, Output> Recipes<Input, Output> readJson(String path, Recipes<Input, Output> defaultRecipe) {
        Recipes newRecipes;
        JsonObject jsonObject = this.readFileToJsonObject(path);
        if (jsonObject == null) {
            this.saveRecipe(path, defaultRecipe);
            return defaultRecipe;
        }
        try {
            newRecipes = new Recipes(defaultRecipe.inputRecipeType, defaultRecipe.outputRecipeType);
            newRecipes.readRecipeJson(jsonObject);
        }
        catch (Exception e) {
            ConfigLoader.logger().error("\u65e0\u6cd5\u8bfb\u53d6\u6587\u4ef6\uff1a{}", (Object)path, (Object)e);
            throw new RuntimeException("\u65e0\u6cd5\u8bfb\u53d6\u6587\u4ef6\uff1a" + path, e);
        }
        return newRecipes;
    }

    public <Input, Output> void saveRecipe(String path, @Nonnull Recipes<Input, Output> defaultRecipe) {
        JsonObject jsonObject = defaultRecipe.getRecipeJson();
        this.saveJson(jsonObject, new File(path));
    }

    public void saveJson(JsonObject jsonObject, @Nonnull File file) {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((JsonElement)jsonObject, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            ConfigLoader.logger().throwing((Throwable)e);
        }
    }

    @Nullable
    private JsonObject readFileToJsonObject(String filePath) {
        JsonObject jsonObject;
        try (FileInputStream in = FileUtils.openInputStream((File)new File(filePath));){
            String content = IOUtils.toString((InputStream)in, (Charset)Charsets.toCharset((String)"UTF-8"));
            jsonObject = new JsonParser().parse(content).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            jsonObject = null;
        }
        catch (Exception e) {
            ConfigLoader.logger().error("{} \u6587\u4ef6\u8bfb\u53d6\u51fa\u9519", (Object)filePath, (Object)e);
            throw new RuntimeException(filePath + " \u6587\u4ef6\u8bfb\u53d6\u51fa\u9519", e);
        }
        return jsonObject;
    }
}

