/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.jsonRecipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.xiaoxianben.watergenerators.jsonRecipe.recipeType.IRecipeType;
import java.util.ArrayList;

public class Recipes<input, output> {
    protected final IRecipeType<input> inputRecipeType;
    protected final IRecipeType<output> outputRecipeType;
    protected ArrayList<input> inputs = new ArrayList();
    protected ArrayList<output> outputs = new ArrayList();
    protected ArrayList<String> recipeNames = new ArrayList();

    public Recipes(IRecipeType<input> inputRecipeType, IRecipeType<output> outputRecipeType) {
        this.inputRecipeType = inputRecipeType;
        this.outputRecipeType = outputRecipeType;
    }

    public void addRecipe(input input, output output) {
        this.inputs.add(input);
        this.outputs.add(output);
    }

    public int size() {
        return this.inputs.size();
    }

    public int indexOfKey(input in) {
        return this.inputs.indexOf(in);
    }

    public boolean containsKay(input in) {
        return this.indexOfKey(in) >= 0;
    }

    public ArrayList<input> getInputs() {
        return this.inputs;
    }

    public input getInput(int i) {
        return this.inputs.get(i);
    }

    public output getOutput(input input) {
        return this.outputs.get(this.inputs.indexOf(input));
    }

    public output getOutput(int i) {
        return this.outputs.get(i);
    }

    public JsonObject getRecipeJson() {
        JsonObject json = new JsonObject();
        for (int i = 0; i < this.size(); ++i) {
            JsonObject recipe = new JsonObject();
            recipe.add("input", (JsonElement)this.inputRecipeType.getRecipeJson(this.getInput(i)));
            recipe.add("output", (JsonElement)this.outputRecipeType.getRecipeJson(this.getOutput(i)));
            json.add(i >= this.recipeNames.size() ? String.valueOf(i) : this.recipeNames.get(i), (JsonElement)recipe);
        }
        return json;
    }

    public void readRecipeJson(JsonObject json) {
        json.entrySet().forEach(entry -> {
            this.recipeNames.add((String)entry.getKey());
            JsonObject recipe = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                this.addRecipe(this.inputRecipeType.getRecipe(recipe.get("input").getAsJsonObject()), this.outputRecipeType.getRecipe(recipe.get("output").getAsJsonObject()));
            }
            catch (Exception e) {
                throw new RuntimeException("\u8bfb\u53d6\u914d\u65b9\u65f6\u53d1\u751f\u9519\u8bef, \u914d\u65b9id\uff1a" + (String)entry.getKey(), e);
            }
        });
    }
}

