/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.jsonRecipe.ingredients;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemOrFluid {
    public ItemStack item = null;
    public FluidStack fluid = null;

    public ItemOrFluid(@Nonnull Item item) {
        this(new ItemStack(item, 1));
    }

    public ItemOrFluid(@Nonnull Fluid fluid) {
        this(new FluidStack(fluid, 1));
    }

    public ItemOrFluid(@Nullable ItemStack item) {
        this.item = item;
    }

    public ItemOrFluid(@Nullable FluidStack fluid) {
        this.fluid = fluid;
    }

    public ItemOrFluid(String name, int amount) {
        if (Item.func_111206_d((String)name) != null) {
            this.item = new ItemStack(Objects.requireNonNull(Item.func_111206_d((String)name)), amount);
        } else if (FluidRegistry.getFluid((String)name) != null) {
            this.fluid = new FluidStack(FluidRegistry.getFluid((String)name), amount);
        } else {
            throw new RuntimeException("Item or Fluid not found: " + name);
        }
    }

    public Object get() {
        return this.item != null ? this.item : this.fluid;
    }

    public int getCount() {
        return this.item != null ? this.item.func_190916_E() : this.fluid.amount;
    }

    public boolean isSame(ItemOrFluid other) {
        return this.item != null && other.item != null ? this.item.func_77969_a(other.item) : this.fluid != null && this.fluid.isFluidEqual(other.fluid);
    }
}

