/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.jsonRecipe.recipeType;

import com.google.gson.JsonObject;
import com.xiaoxianben.watergenerators.jsonRecipe.ingredients.FluidStackAndEnergy;
import com.xiaoxianben.watergenerators.jsonRecipe.recipeType.IRecipeType;
import com.xiaoxianben.watergenerators.jsonRecipe.recipeType.RecipeFloat;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RecipeTypes {
    public static final IRecipeType<ItemStack> recipe_itemStack = new IRecipeType<ItemStack>(){

        @Override
        public Class<ItemStack> getClassType() {
            return ItemStack.class;
        }

        @Override
        public JsonObject getRecipeJson(ItemStack itemStack) {
            JsonObject json = new JsonObject();
            String name = Objects.requireNonNull(itemStack.func_77973_b().getRegistryName()).toString();
            int count = itemStack.func_190916_E();
            json.addProperty("name", name);
            json.addProperty("count", (Number)count);
            return json;
        }

        @Override
        public ItemStack getRecipe(JsonObject json) {
            return new ItemStack(Objects.requireNonNull(Item.func_111206_d((String)json.get("name").getAsString())), json.get("count").getAsInt());
        }
    };
    public static final IRecipeType<FluidStack> recipe_fluidStack = new IRecipeType<FluidStack>(){

        @Override
        public Class<FluidStack> getClassType() {
            return FluidStack.class;
        }

        @Override
        public JsonObject getRecipeJson(FluidStack fluidStack) {
            JsonObject json = new JsonObject();
            String name = Objects.requireNonNull(fluidStack.getFluid().getName());
            json.addProperty("name", name);
            json.addProperty("count", (Number)fluidStack.amount);
            return json;
        }

        @Override
        public FluidStack getRecipe(JsonObject json) {
            return new FluidStack(FluidRegistry.getFluid((String)json.get("name").getAsString()), json.get("count").getAsInt());
        }
    };
    public static final IRecipeType<FluidStackAndEnergy> recipe_fluidStackAndEnergy = new IRecipeType<FluidStackAndEnergy>(){

        @Override
        public Class<FluidStackAndEnergy> getClassType() {
            return FluidStackAndEnergy.class;
        }

        @Override
        public JsonObject getRecipeJson(FluidStackAndEnergy o) {
            JsonObject json = new JsonObject();
            FluidStack fluidStack1 = o.getFluidStack1();
            String name = Objects.requireNonNull(fluidStack1.getFluid().getName());
            json.addProperty("name", name);
            json.addProperty("count", (Number)fluidStack1.amount);
            json.addProperty("energy", (Number)o.getEnergyValue());
            return json;
        }

        @Override
        public FluidStackAndEnergy getRecipe(JsonObject json) {
            FluidStack fluidStack = new FluidStack(FluidRegistry.getFluid((String)json.get("name").getAsString()), json.get("count").getAsInt());
            return new FluidStackAndEnergy(fluidStack, json.get("energy").getAsInt());
        }
    };
    public static final IRecipeType<Fluid> recipe_fluid = new IRecipeType<Fluid>(){

        @Override
        public Class<Fluid> getClassType() {
            return Fluid.class;
        }

        @Override
        public JsonObject getRecipeJson(Fluid fluid) {
            JsonObject json = new JsonObject();
            String name = Objects.requireNonNull(fluid.getName());
            json.addProperty("name", name);
            return json;
        }

        @Override
        public Fluid getRecipe(JsonObject json) {
            return FluidRegistry.getFluid((String)json.get("name").getAsString());
        }
    };
    public static final IRecipeType<Float> recipe_float = new RecipeFloat("multiplier");
}

