/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.tileEntity;

import com.xiaoxianben.watergenerators.api.IHasItemNBT;
import com.xiaoxianben.watergenerators.enery.EnergyStorage;
import com.xiaoxianben.watergenerators.tileEntity.TEBase;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class TEEnergyBasic
extends TEBase
implements IEnergyStorage,
IHasItemNBT {
    public long finallyReceiveEnergy;
    public long finallyExtractEnergy;
    protected final HashSet<EnumFacing> transferEnergyFacings = new HashSet();
    protected final HashSet<Long> finallyExtractEnergyList = new HashSet();
    protected final EnergyStorage energyStorage;

    public TEEnergyBasic(long capacity, boolean canReceive, boolean canExtract) {
        this.energyStorage = new EnergyStorage(capacity, canReceive, canExtract);
    }

    protected long getFinallyExtractEnergyP() {
        AtomicLong rf = new AtomicLong();
        this.finallyExtractEnergyList.forEach(rf::addAndGet);
        return rf.get();
    }

    public long getFinallyExtractEnergy() {
        return this.finallyExtractEnergy;
    }

    public long getFinallyReceiveEnergy() {
        return this.finallyReceiveEnergy;
    }

    protected boolean updateTransferFacings(World world) {
        this.transferEnergyFacings.clear();
        this.finallyExtractEnergyList.clear();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.canTransferEnergy(world.func_175625_s(this.func_174877_v().func_177972_a(facing)), facing.func_176734_d())) continue;
            this.transferEnergyFacings.add(facing);
        }
        return !this.transferEnergyFacings.isEmpty();
    }

    protected boolean canTransferEnergy(TileEntity TE, EnumFacing facing) {
        if (TE != null && TE.hasCapability(CapabilityEnergy.ENERGY, facing)) {
            IEnergyStorage iEnergyStorage = (IEnergyStorage)Objects.requireNonNull(TE.getCapability(CapabilityEnergy.ENERGY, facing));
            return iEnergyStorage.receiveEnergy(this.getEnergyStored(), true) != 0;
        }
        return false;
    }

    protected void transferEnergy(TileEntity adjacentTE, EnumFacing facing) {
        int temp = ((IEnergyStorage)Objects.requireNonNull(adjacentTE.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()))).receiveEnergy(this.getEnergyStored(), false);
        this.finallyExtractEnergyList.add(this.modifyEnergyStored(-temp));
    }

    protected abstract long updateEnergy();

    @Override
    public void updateStateInSever() {
        if (this.canExtract() && this.updateTransferFacings(this.field_145850_b)) {
            for (EnumFacing facing : this.transferEnergyFacings) {
                this.transferEnergy(Objects.requireNonNull(this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing))), facing);
            }
            this.finallyExtractEnergy = this.getFinallyExtractEnergyP();
        } else {
            this.finallyExtractEnergy = 0L;
        }
        this.finallyReceiveEnergy = this.updateEnergy();
    }

    protected long modifyEnergyStored(long energy) {
        return this.energyStorage.modifyEnergyStored(energy);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    public long getEnergyStoredLong() {
        return this.energyStorage.getEnergyStoredLong();
    }

    public long getMaxEnergyStoredLong() {
        return this.energyStorage.getMaxEnergyStoredLong();
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound getCapabilityNBT() {
        return this.energyStorage.writeToNBT(new NBTTagCompound());
    }

    @Override
    public void readCapabilityNBT(NBTTagCompound NBT2) {
        this.energyStorage.readFromNBT(NBT2);
    }

    @Override
    public NBTTagCompound getItemNbt() {
        NBTTagCompound NBT2 = new NBTTagCompound();
        NBT2.func_74772_a("Energy", this.getEnergyStoredLong());
        return NBT2;
    }

    @Override
    public void readItemNbt(NBTTagCompound NBT2) {
        this.modifyEnergyStored(NBT2.func_74763_f("Energy"));
    }
}

