/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.tileEntity.generator;

import com.xiaoxianben.watergenerators.api.IComponentItemHandler;
import com.xiaoxianben.watergenerators.items.ItemsComponent;
import com.xiaoxianben.watergenerators.items.itemHandler.ItemComponentHandler;
import com.xiaoxianben.watergenerators.items.itemHandler.ItemStackHandler;
import com.xiaoxianben.watergenerators.tileEntity.TEEnergyBasic;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TEGeneratorBase
extends TEEnergyBasic
implements IComponentItemHandler {
    public long basePowerGeneration;
    protected ItemComponentHandler itemComponentHandler;

    public TEGeneratorBase(long basePowerGeneration) {
        super(basePowerGeneration, false, true);
        this.basePowerGeneration = basePowerGeneration;
        this.itemComponentHandler = new ItemComponentHandler(ItemComponentHandler.canPutItem_generator);
    }

    public long getFinallyPowerGeneration() {
        return this.basePowerGeneration * (long)(this.itemComponentHandler.getComponentCount(ItemsComponent.component_powerGeneration) + 1);
    }

    @Override
    public ItemStackHandler getComponentItemHandler() {
        return this.itemComponentHandler;
    }

    @Override
    @ParametersAreNonnullByDefault
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemComponentHandler);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound getCapabilityNBT() {
        NBTTagCompound nbtTagCompound = super.getCapabilityNBT();
        nbtTagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemComponentHandler.serializeNBT());
        return nbtTagCompound;
    }

    @Override
    public void readCapabilityNBT(NBTTagCompound NBT2) {
        super.readCapabilityNBT(NBT2);
        this.itemComponentHandler.deserializeNBT(NBT2.func_74775_l("ItemHandler"));
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound NBT2) {
        NBTTagCompound nbtGenerator = NBT2.func_74775_l("Attribute");
        this.basePowerGeneration = nbtGenerator.func_74763_f("basePowerGeneration");
        super.func_145839_a(NBT2);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(compound);
        NBTTagCompound nbtGenerator = new NBTTagCompound();
        nbtGenerator.func_74772_a("basePowerGeneration", this.basePowerGeneration);
        nbtTagCompound.func_74782_a("Attribute", (NBTBase)nbtGenerator);
        return nbtTagCompound;
    }

    @Override
    public NBTTagCompound getNetworkUpdateNBT() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74772_a("finallyReceiveEnergy", this.finallyReceiveEnergy);
        nbtTagCompound.func_74772_a("finallyExtractEnergy", this.finallyExtractEnergy);
        return nbtTagCompound;
    }

    @Override
    public void readNetworkUpdateNBT(NBTTagCompound NBT2) {
        this.finallyReceiveEnergy = NBT2.func_74763_f("finallyReceiveEnergy");
        this.finallyExtractEnergy = NBT2.func_74763_f("finallyExtractEnergy");
    }
}

