/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.tileEntity.generator;

import com.xiaoxianben.watergenerators.config.ConfigValue;
import com.xiaoxianben.watergenerators.fluids.fluidTank.FluidTankGenerator;
import com.xiaoxianben.watergenerators.items.ItemsComponent;
import com.xiaoxianben.watergenerators.items.itemHandler.ItemComponentHandler;
import com.xiaoxianben.watergenerators.jsonRecipe.ModJsonRecipe;
import com.xiaoxianben.watergenerators.tileEntity.generator.TEGeneratorBase;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TEGeneratorFluid
extends TEGeneratorBase {
    public final int basicAmountOfFluidToProduceEnergy = ConfigValue.basicAmountOfFluidToProduceEnergy;
    public FluidTankGenerator fluidTank = new FluidTankGenerator(65 * this.basicAmountOfFluidToProduceEnergy, ModJsonRecipe.recipeFluidGenerator.getInputs());
    private int maxFluidDrain;

    public TEGeneratorFluid() {
        this(Long.MAX_VALUE);
    }

    public TEGeneratorFluid(long basePowerGeneration) {
        super(basePowerGeneration);
        this.fluidTank.setCanDrain(false);
        this.itemComponentHandler = new ItemComponentHandler(ItemComponentHandler.canPutItem_fluidGenerator);
    }

    public float getFluidAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public float getCapacity() {
        return this.fluidTank.getCapacity();
    }

    public float getEnergyMagnification() {
        if (this.fluidTank.getFluid() != null && ModJsonRecipe.recipeFluidGenerator.containsKay(this.fluidTank.getFluid().getFluid())) {
            return ModJsonRecipe.recipeFluidGenerator.getOutput(this.fluidTank.getFluid().getFluid()).floatValue();
        }
        return 0.0f;
    }

    @Override
    public long getFinallyPowerGeneration() {
        return (long)((float)super.getFinallyPowerGeneration() * this.getEnergyMagnification());
    }

    @Override
    protected long updateEnergy() {
        long receiveEnergy = 0L;
        FluidStack fluid = this.fluidTank.getFluid();
        if (fluid != null && this.getEnergyStoredLong() < this.getMaxEnergyStoredLong() && fluid.amount >= this.basicAmountOfFluidToProduceEnergy) {
            int canDrainAmount;
            long realPowerGeneration = this.getFinallyPowerGeneration();
            int theAmountOfFluidRequired = (int)(Math.max((this.getMaxEnergyStoredLong() - this.getEnergyStoredLong()) / realPowerGeneration, 1L) * (long)this.basicAmountOfFluidToProduceEnergy);
            FluidStack fluidStack = this.fluidTank.drainInternal(Math.min(theAmountOfFluidRequired, canDrainAmount = Math.min(fluid.amount / this.basicAmountOfFluidToProduceEnergy * this.basicAmountOfFluidToProduceEnergy, this.maxFluidDrain)), true);
            if (fluidStack != null) {
                receiveEnergy = (long)(fluidStack.amount / this.basicAmountOfFluidToProduceEnergy) * realPowerGeneration;
            }
        }
        return this.modifyEnergyStored(receiveEnergy);
    }

    @Override
    public void updateStateInSever() {
        int extractCount = this.itemComponentHandler.getComponentCount(ItemsComponent.component_extract) + 1;
        this.maxFluidDrain = extractCount * this.basicAmountOfFluidToProduceEnergy;
        this.energyStorage.setCapacity(Math.max(this.getFinallyPowerGeneration() * (long)extractCount * 2L, this.getEnergyStoredLong()));
        super.updateStateInSever();
    }

    @Override
    public NBTTagCompound getItemNbt() {
        NBTTagCompound NBT2 = super.getItemNbt();
        if (this.fluidTank.getFluid() != null) {
            this.fluidTank.getFluid().writeToNBT(NBT2);
        }
        return NBT2;
    }

    @Override
    public void readItemNbt(NBTTagCompound NBT2) {
        super.readItemNbt(NBT2);
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)NBT2);
        if (fluidStack != null && this.fluidTank.canFillFluidType(fluidStack)) {
            this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)NBT2));
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidTank);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemComponentHandler);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound getCapabilityNBT() {
        NBTTagCompound nbtTagCompound = super.getCapabilityNBT();
        NBTTagCompound nbtFluidTank = this.fluidTank.writeToNBT(new NBTTagCompound());
        nbtTagCompound.func_74782_a("FluidTank", (NBTBase)nbtFluidTank);
        return nbtTagCompound;
    }

    @Override
    public void readCapabilityNBT(NBTTagCompound NBT2) {
        super.readCapabilityNBT(NBT2);
        NBTTagCompound nbtFluidTank = NBT2.func_74775_l("FluidTank");
        this.fluidTank.readFromNBT(nbtFluidTank);
    }
}

