/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.tileEntity.generator;

import com.xiaoxianben.watergenerators.jsonRecipe.ModJsonRecipe;
import com.xiaoxianben.watergenerators.tileEntity.generator.TEGeneratorBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public class TEGeneratorTurbine
extends TEGeneratorBase {
    protected float fluidHeight = 0.0f;

    public TEGeneratorTurbine() {
        this(Long.MAX_VALUE);
    }

    public TEGeneratorTurbine(long basePowerGeneration) {
        super(basePowerGeneration);
    }

    public float getLiquidHeight() {
        float liquidHeight = 0.0f;
        BlockPos blockPos = this.func_174877_v().func_177984_a();
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)this.func_145831_w().func_180495_p(blockPos).func_177230_c());
        while (ModJsonRecipe.recipeFluidGenerator.containsKay(fluid) && fluid.getDensity() > 0) {
            liquidHeight += ModJsonRecipe.recipeFluidGenerator.getOutput(fluid).floatValue() * this.getLiquidLevel(this.func_145831_w(), blockPos);
            blockPos = blockPos.func_177984_a();
            fluid = FluidRegistry.lookupFluidForBlock((Block)this.func_145831_w().func_180495_p(blockPos).func_177230_c());
        }
        return liquidHeight;
    }

    protected float getLiquidLevel(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).getFilledPercentage(world, pos);
        }
        if (block instanceof BlockLiquid) {
            int _level = (int)(BlockLiquid.func_190973_f((IBlockState)world.func_180495_p(pos), (IBlockAccess)world, (BlockPos)pos) * 10.0f);
            if (_level <= 8) {
                return (float)_level / 8.0f;
            }
            return (float)_level / 10.0f;
        }
        return 0.0f;
    }

    @Override
    public long updateEnergy() {
        long receiveEnergy = 0L;
        if (this.getEnergyStoredLong() < this.getMaxEnergyStoredLong()) {
            receiveEnergy = (int)((float)this.getFinallyPowerGeneration() * this.fluidHeight);
        }
        return this.modifyEnergyStored(receiveEnergy);
    }

    @Override
    public void updateStateInSever() {
        this.fluidHeight = this.getLiquidHeight();
        this.energyStorage.setCapacity(Math.max((long)Math.ceil((float)this.getFinallyPowerGeneration() * this.fluidHeight * 2.0f), this.getEnergyStoredLong()));
        super.updateStateInSever();
    }
}

