/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.tileEntity.machine;

import com.xiaoxianben.watergenerators.api.IComponentItemHandler;
import com.xiaoxianben.watergenerators.config.ConfigValue;
import com.xiaoxianben.watergenerators.fluids.fluidTank.FluidTankBase;
import com.xiaoxianben.watergenerators.fluids.fluidTank.FluidTankRecipe;
import com.xiaoxianben.watergenerators.items.ItemsComponent;
import com.xiaoxianben.watergenerators.items.itemHandler.ItemComponentHandler;
import com.xiaoxianben.watergenerators.items.itemHandler.ItemStackHandler;
import com.xiaoxianben.watergenerators.jsonRecipe.ModJsonRecipe;
import com.xiaoxianben.watergenerators.jsonRecipe.ingredients.FluidStackAndEnergy;
import com.xiaoxianben.watergenerators.tileEntity.machine.TEMachineBase;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;

public class TEMachineVaporization
extends TEMachineBase
implements IComponentItemHandler {
    protected final int runNumber = ConfigValue.basicAmountOfFluidToProduceEnergy / 5;
    protected FluidTankRecipe fluidTankInt;
    protected FluidTankBase fluidTankOut;
    protected ItemComponentHandler itemComponentHandler;

    public TEMachineVaporization() {
        this(999.0f);
    }

    public TEMachineVaporization(float level) {
        super(level);
        this.fluidTankInt = new FluidTankRecipe((int)(10000.0f * level), ModJsonRecipe.recipeVaporization);
        this.fluidTankOut = new FluidTankBase((int)(10000.0f * level));
        this.itemComponentHandler = new ItemComponentHandler(ItemComponentHandler.canPutItem_vaporization);
        this.fluidTankInt.setCanDrain(false);
        this.fluidTankInt.setCanFill(true);
        this.fluidTankOut.setCanDrain(true);
        this.fluidTankOut.setCanFill(false);
    }

    public FluidTankRecipe getFluidTankInt() {
        return this.fluidTankInt;
    }

    public FluidTankBase getFluidTankOut() {
        return this.fluidTankOut;
    }

    @ParametersAreNonnullByDefault
    private void runMachine(FluidStack inputFluid, FluidStack outputFluid, int energyDe) {
        this.modifyEnergyStored(-energyDe);
        this.fluidTankOut.fillInternal(outputFluid.copy(), true);
        this.fluidTankInt.drainInternal(inputFluid.copy(), true);
    }

    @ParametersAreNonnullByDefault
    private int getNumberRun(FluidStack recipeInputFluid, FluidStack recipeOutputFluid, int energyDe) {
        if (this.getEnergyStoredLong() < (long)energyDe) {
            return 0;
        }
        int outFluidNumber = (this.fluidTankOut.getCapacity() - this.fluidTankOut.getFluidAmount()) / recipeOutputFluid.amount;
        int inputFluidNumber = this.fluidTankInt.getFluidAmount() / recipeInputFluid.amount;
        long energyNumber = this.getEnergyStoredLong() / (long)energyDe;
        return (int)Math.min((long)Math.min(outFluidNumber, inputFluidNumber), energyNumber);
    }

    @Override
    public void updateStateInSever() {
        this.open = false;
        FluidStack recipeFluidInput = this.fluidTankInt.getRecipeFluidInput();
        if (recipeFluidInput == null) {
            return;
        }
        FluidStackAndEnergy recipeOutput = this.fluidTankInt.getRecipeOutput();
        if (recipeOutput == null) {
            return;
        }
        int energyDepleteValue = -recipeOutput.getEnergyValue();
        int numberRun = (int)Math.min((float)this.getNumberRun(recipeFluidInput, recipeOutput.getFluidStack1(), energyDepleteValue), this.getLevel() * (float)this.runNumber * (float)(this.itemComponentHandler.getComponentCount(ItemsComponent.component_efficiency) + 1));
        if (numberRun <= 0) {
            return;
        }
        this.open = true;
        for (int i = 0; i < numberRun; ++i) {
            this.runMachine(recipeFluidInput, recipeOutput.getFluidStack1(), energyDepleteValue);
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerConcatenate(new IFluidHandler[]{this.fluidTankInt, this.fluidTankOut}));
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound getCapabilityNBT() {
        NBTTagCompound nbtTagCompound = super.getCapabilityNBT();
        NBTTagCompound nbtFluidTank = new NBTTagCompound();
        nbtFluidTank.func_74782_a("Int", (NBTBase)this.fluidTankInt.writeToNBT(new NBTTagCompound()));
        nbtFluidTank.func_74782_a("Out", (NBTBase)this.fluidTankOut.writeToNBT(new NBTTagCompound()));
        nbtTagCompound.func_74782_a("FluidTank", (NBTBase)nbtFluidTank);
        nbtTagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemComponentHandler.serializeNBT());
        return nbtTagCompound;
    }

    @Override
    public void readCapabilityNBT(NBTTagCompound NBT2) {
        super.readCapabilityNBT(NBT2);
        NBTTagCompound nbtFluidTank = NBT2.func_74775_l("FluidTank");
        this.fluidTankInt.readFromNBT(nbtFluidTank.func_74775_l("Int"));
        this.fluidTankOut.readFromNBT(nbtFluidTank.func_74775_l("Out"));
        this.itemComponentHandler.deserializeNBT(NBT2.func_74775_l("ItemHandler"));
    }

    @Override
    public NBTTagCompound getItemNbt() {
        NBTTagCompound NBT2 = super.getItemNbt();
        NBTTagCompound inputFluidNbt = new NBTTagCompound();
        if (this.fluidTankInt.getFluid() != null) {
            this.fluidTankInt.writeToNBT(inputFluidNbt);
        }
        NBT2.func_74782_a("inputFluid", (NBTBase)inputFluidNbt);
        NBTTagCompound outputFluidNbt = new NBTTagCompound();
        if (this.fluidTankOut.getFluid() != null) {
            this.fluidTankOut.writeToNBT(outputFluidNbt);
        }
        NBT2.func_74782_a("outputFluid", (NBTBase)outputFluidNbt);
        return NBT2;
    }

    @Override
    public void readItemNbt(NBTTagCompound NBT2) {
        super.readItemNbt(NBT2);
        NBTTagCompound inputFluidNbt = NBT2.func_74775_l("inputFluid");
        this.fluidTankInt.readFromNBT(inputFluidNbt);
        NBTTagCompound outputFluidNbt = NBT2.func_74775_l("outputFluid");
        this.fluidTankOut.readFromNBT(outputFluidNbt);
    }

    @Override
    public ItemStackHandler getComponentItemHandler() {
        return this.itemComponentHandler;
    }
}

