/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.mc.spm.menu;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.eu.hanana.reimu.mc.spm.item.component.ComponentRegisterHandler;
import org.eu.hanana.reimu.mc.spm.item.component.FilterData;
import org.eu.hanana.reimu.mc.spm.menu.MenuRegisterHandler;

public class FilterConfigMenu
extends AbstractContainerMenu {
    public final Inventory playerInventory;
    public final ItemStackHandler filterListInv = new ItemStackHandler(this){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            boolean f = false;
            for (int i = 0; i < this.getSlots() && !(f = this.getStackInSlot(i).is(stack.getItem())); ++i) {
            }
            return !f && super.isItemValid(slot, stack);
        }
    };
    public int filterShotStart;
    public int filterShotAmount;

    public FilterConfigMenu(int containerId, Inventory playerInventory) {
        super((MenuType)MenuRegisterHandler.Filter_Config_Menu.get(), containerId);
        this.playerInventory = playerInventory;
        ItemStack is = playerInventory.player.getMainHandItem();
        FilterData data = (FilterData)is.get((DataComponentType)ComponentRegisterHandler.ITEM_FILTER.get());
        if (data == null) {
            playerInventory.player.sendSystemMessage((Component)Component.literal((String)"What?! Item in main hand doesn't have ITEM_FILTER component!").withColor(0xFF1010));
            return;
        }
        int i = -18;
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)playerInventory, j1 + l * 9 + 9, 8 + j1 * 18, 103 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 161 + i));
        }
        this.filterShotStart = this.slots.size();
        this.filterShotAmount = data.getSize();
        this.filterListInv.setSize(this.filterShotAmount);
        int blocks = (int)Math.ceil((float)this.filterShotAmount / 9.0f);
        ArrayList<FSlotItemHandler> slots1 = new ArrayList<FSlotItemHandler>();
        int maxW = 0;
        int maxH = 0;
        for (int blk = 0; blk < blocks; ++blk) {
            for (int j = 0; j < 3; ++j) {
                int placedSlots;
                for (int col = 0; col < 3 && (placedSlots = slots1.size()) < this.filterShotAmount; ++col) {
                    int x = col * 18 + blk * 54;
                    int y = j * 18;
                    maxH = Math.max(maxH, j * 18 + 18);
                    maxW = Math.max(maxW, col * 18 + blk * 54 + 18);
                    slots1.add(new FSlotItemHandler((IItemHandler)this.filterListInv, placedSlots, x, y));
                }
            }
        }
        for (Slot slot : slots1) {
            slot.x += 88 - maxW / 2;
            slot.y += 45 - maxH / 2;
        }
        slots1.forEach(x$0 -> this.addSlot((Slot)x$0));
        for (int i1 = 0; i1 < data.itemNames.size(); ++i1) {
            ResourceLocation resourceLocation = data.itemNames.get(i1);
            if (i1 > this.filterListInv.getSlots() - 1) break;
            this.filterListInv.setStackInSlot(i1, ((Item)BuiltInRegistries.ITEM.get(resourceLocation)).getDefaultInstance());
        }
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (slotId < 0) {
            super.clicked(slotId, button, clickType, player);
            return;
        }
        if (clickType == ClickType.QUICK_CRAFT && slotId >= this.filterShotStart && slotId < this.filterShotStart + this.filterShotAmount) {
            return;
        }
        ItemStack is = this.getSlot(slotId).getItem();
        if (is.equals(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return player.getMainHandItem().has((DataComponentType)ComponentRegisterHandler.ITEM_FILTER.get());
    }

    public void removed(Player player) {
        ItemStack is = this.playerInventory.player.getMainHandItem();
        FilterData data = (FilterData)is.get((DataComponentType)ComponentRegisterHandler.ITEM_FILTER.get());
        ArrayList<ResourceLocation> itemNames = new ArrayList<ResourceLocation>();
        for (int i = 0; i < this.filterListInv.getSlots(); ++i) {
            ItemStack item = this.filterListInv.getStackInSlot(i);
            if (item.isEmpty()) continue;
            itemNames.add(BuiltInRegistries.ITEM.getKey((Object)item.getItem()));
        }
        FilterData newData = new FilterData(data.getMode(), data.getSize(), itemNames);
        is.set((DataComponentType)ComponentRegisterHandler.ITEM_FILTER.get(), (Object)newData);
        super.removed(player);
    }

    private static class FSlotItemHandler
    extends SlotItemHandler {
        public FSlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public ItemStack safeInsert(ItemStack stack, int increment) {
            super.safeInsert(stack.copy(), increment);
            return stack.copy();
        }

        public ItemStack safeTake(int count, int decrement, Player player) {
            super.safeTake(count, decrement, player);
            return ItemStack.EMPTY;
        }

        public Optional<ItemStack> tryRemove(int count, int decrement, Player player) {
            super.tryRemove(count, decrement, player);
            return Optional.of(ItemStack.EMPTY);
        }
    }
}

