/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.mc.spm.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.eu.hanana.reimu.mc.spm.Util;
import org.eu.hanana.reimu.mc.spm.item.component.ComponentRegisterHandler;
import org.eu.hanana.reimu.mc.spm.item.component.FilterData;
import org.eu.hanana.reimu.mc.spm.recipe.RecipeRegisterHandler;

public class FilterRecipe
extends CustomRecipe {
    public Map<Item, Integer> upgradeLevels = new HashMap<Item, Integer>();

    public FilterRecipe(CraftingBookCategory category) {
        super(category);
        this.upgradeLevels.put(Items.IRON_INGOT, 6);
        this.upgradeLevels.put(Items.GOLD_INGOT, 9);
        this.upgradeLevels.put(Items.DIAMOND, 18);
        this.upgradeLevels.put(Items.NETHERITE_INGOT, 27);
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.isEmpty()) {
            return false;
        }
        ItemStack target = null;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : input.items()) {
            if (item.isEmpty()) continue;
            if (item.has(ComponentRegisterHandler.ITEM_FILTER)) {
                target = item;
                continue;
            }
            items.add(item);
        }
        if (items.size() != 1) {
            return false;
        }
        ItemStack upgrade = (ItemStack)items.getFirst();
        return target != null && this.upgradeLevels.containsKey(upgrade.getItem());
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack target = null;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : input.items()) {
            if (item.isEmpty()) continue;
            if (item.has(ComponentRegisterHandler.ITEM_FILTER)) {
                target = item;
                continue;
            }
            items.add(item);
        }
        ItemStack upgrade = (ItemStack)items.getFirst();
        FilterData clone = ((FilterData)target.get(ComponentRegisterHandler.ITEM_FILTER)).clone();
        clone.size = this.upgradeLevels.get(upgrade.getItem());
        return Util.writeData(target.copy(), (DataComponentType)ComponentRegisterHandler.ITEM_FILTER.get(), clone);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegisterHandler.FILTER_UPGRADE_RECIPE_SERIALIZER.get();
    }
}

