/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.mc.spm.screen;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.PacketDistributor;
import org.eu.hanana.reimu.mc.spm.item.component.ComponentRegisterHandler;
import org.eu.hanana.reimu.mc.spm.item.component.FilterData;
import org.eu.hanana.reimu.mc.spm.menu.FilterConfigMenu;
import org.eu.hanana.reimu.mc.spm.network.SetFilterModeData;

public class FilterConfigScreen
extends AbstractContainerScreen<FilterConfigMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    private static final ResourceLocation DEMO_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/demo_background.png");
    private static final ResourceLocation BUTTONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"stoppicking", (String)"textures/gui/button.png");
    protected FilterData filterData = new FilterData("", 1, List.of());

    public FilterConfigScreen(FilterConfigMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
        this.filterData = (FilterData)((FilterConfigMenu)this.getMenu()).playerInventory.player.getMainHandItem().get(ComponentRegisterHandler.ITEM_FILTER);
        this.clearWidgets();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)""), button -> PacketDistributor.sendToServer((CustomPacketPayload)new SetFilterModeData(this.filterData.mode.equals("black") ? "white" : "black"), (CustomPacketPayload[])new CustomPacketPayload[0])).bounds(this.getGuiLeft() - 23, this.getGuiTop() + 22, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui.stoppicking.filter." + this.filterData.mode)))).build());
    }

    protected void containerTick() {
        super.containerTick();
        FilterData filterData = (FilterData)((FilterConfigMenu)this.getMenu()).playerInventory.player.getMainHandItem().get(ComponentRegisterHandler.ITEM_FILTER);
        if (filterData != this.filterData) {
            this.filterData = filterData;
            this.minecraft.tell(this::init);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(BUTTONS_TEXTURE, this.getGuiLeft() - 20, this.getGuiTop() + 24, 15, 14, 0.0f, this.filterData.mode.equals("black") ? 64.0f : 0.0f, 64, 64, 512, 512);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(CONTAINER_BACKGROUND, i, j + 71, 0, 126, this.imageWidth, 96);
        guiGraphics.blit(DEMO_BACKGROUND, i, j, 0, 0, this.imageWidth - 18, 71);
        guiGraphics.blit(DEMO_BACKGROUND, i + this.imageWidth - 18, j, 230, 0, 20, 71);
        guiGraphics.blit(DEMO_BACKGROUND, i - 30, j + 15, 0, 0, 33, 55);
        guiGraphics.blit(DEMO_BACKGROUND, i - 30, j + 60, 0, 150, 33, 55);
        for (int i1 = ((FilterConfigMenu)this.menu).filterShotStart; i1 < ((FilterConfigMenu)this.menu).filterShotAmount + ((FilterConfigMenu)this.menu).filterShotStart; ++i1) {
            Slot slot = ((FilterConfigMenu)this.menu).getSlot(i1);
            guiGraphics.blit(CONTAINER_BACKGROUND, i + slot.x - 1, j + slot.y - 1, 7, 17, 18, 18);
        }
    }
}

