/*
 * Decompiled with CFR 0.152.
 */
package arr.armuriii.goated.copper_horn.item;

import arr.armuriii.goated.Goated;
import arr.armuriii.goated.copper_horn.CopperHornInstrument;
import arr.armuriii.goated.copper_horn.registries.GoatedCopperHornRegistries;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2428;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class CopperHornItem
extends class_1792 {
    public static final String INSTRUMENT_KEY = "instrument";
    private final class_6862<CopperHornInstrument> instrumentTag;

    public CopperHornItem(class_1792.class_1793 settings, class_6862<CopperHornInstrument> instrumentTag) {
        super(settings);
        this.instrumentTag = instrumentTag;
        class_2347 DISPENSER_BEHAVIOR = new class_2347(){

            protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
                return CopperHornItem.this.playGoatHornSound(pointer, stack) ? stack : super.method_10135(pointer, stack);
            }
        };
        class_2315.method_10009((class_1935)this, (class_2357)DISPENSER_BEHAVIOR);
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    private boolean playGoatHornSound(class_2342 pointer, class_1799 horn) {
        class_2350 direction = (class_2350)pointer.method_10120().method_11654((class_2769)class_2315.field_10918);
        class_2338 blockPos = pointer.method_10122().method_10093((class_2350)pointer.method_10120().method_11654((class_2769)class_2315.field_10918));
        class_2680 blockState = pointer.method_10207().method_8320(blockPos);
        float pitch = 1.0f;
        if (blockState.method_26204() instanceof class_2428) {
            pitch = class_2428.method_49818((int)((Integer)blockState.method_11654((class_2769)class_2741.field_12524)));
        }
        if (this.getInstrument(horn).isPresent()) {
            CopperHornInstrument instrument = (CopperHornInstrument)this.getInstrument(horn).get().comp_349();
            if (class_1890.method_8225((class_1887)Goated.SYMPHONY, (class_1799)horn) >= 1) {
                CopperHornItem.playSymphonySound((class_1937)pointer.method_10207(), blockPos, instrument, pitch);
            } else {
                CopperHornItem.playSound((class_1937)pointer.method_10207(), blockPos, instrument, direction, pitch);
            }
            return true;
        }
        return false;
    }

    private static void playSound(class_1937 world, class_2338 blockPos, CopperHornInstrument instrument, class_2350 direction, float pitch) {
        class_3414 soundEvent = switch (direction) {
            case class_2350.field_11036 -> instrument.harmonySoundEvent();
            case class_2350.field_11033 -> instrument.bassSoundEvent();
            default -> instrument.melodySoundEvent();
        };
        float f = instrument.range() / 16.0f;
        world.method_8396(null, blockPos, soundEvent, class_3419.field_15247, f, pitch);
        world.method_43276(class_5712.field_39415, blockPos, class_5712.class_7397.method_43287((class_2680)world.method_8320(blockPos)));
    }

    private static void playSymphonySound(class_1937 world, class_2338 blockPos, CopperHornInstrument instrument, float pitch) {
        class_3414 melody = instrument.melodySoundEvent();
        class_3414 harmony = instrument.harmonySoundEvent();
        class_3414 bass = instrument.bassSoundEvent();
        float f = instrument.range() / 16.0f;
        world.method_8396(null, blockPos, melody, class_3419.field_15247, f, pitch);
        world.method_8396(null, blockPos, harmony, class_3419.field_15247, f, pitch);
        world.method_8396(null, blockPos, bass, class_3419.field_15247, f, pitch);
        world.method_43276(class_5712.field_39415, blockPos, class_5712.class_7397.method_43287((class_2680)world.method_8320(blockPos)));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        Optional optional = this.getInstrument(stack).flatMap(class_6880::method_40230);
        if (optional.isPresent()) {
            class_5250 mutableText = class_2561.method_43471((String)class_156.method_646((String)INSTRUMENT_KEY, (class_2960)((class_5321)optional.get()).method_29177()));
            tooltip.add((class_2561)mutableText.method_27692(class_124.field_1080));
        }
    }

    public static class_1799 getStackForInstrument(class_1792 item, class_6880<CopperHornInstrument> instrument) {
        class_1799 itemStack = new class_1799((class_1935)item);
        CopperHornItem.setInstrument(itemStack, instrument);
        return itemStack;
    }

    public static class_1799 getStackForInstrument(class_1792 item, class_5321<CopperHornInstrument> instrument) {
        class_1799 itemStack = new class_1799((class_1935)item);
        CopperHornItem.setInstrument(itemStack, instrument);
        return itemStack;
    }

    public static void setInstrument(class_1799 stack, class_6880<CopperHornInstrument> instrument) {
        class_2487 nbtCompound = stack.method_7948();
        nbtCompound.method_10582(INSTRUMENT_KEY, ((class_5321)instrument.method_40230().orElseThrow(() -> new IllegalStateException("Invalid instrument"))).method_29177().toString());
    }

    public static void setInstrument(class_1799 stack, class_5321<CopperHornInstrument> instrument) {
        class_2487 nbtCompound = stack.method_7948();
        nbtCompound.method_10582(INSTRUMENT_KEY, instrument.method_29177().toString());
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        Optional<? extends class_6880<CopperHornInstrument>> optional = this.getInstrument(itemStack);
        if (optional.isPresent()) {
            CopperHornInstrument instrument = (CopperHornInstrument)optional.get().comp_349();
            user.method_6019(hand);
            if (class_1890.method_8225((class_1887)Goated.SYMPHONY, (class_1799)itemStack) >= 1) {
                CopperHornItem.playSymphonySound(world, user, instrument);
            } else {
                CopperHornItem.playSound(world, user, instrument);
            }
            user.method_7357().method_7906((class_1792)this, instrument.useDuration());
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public int method_7881(class_1799 stack) {
        Optional<? extends class_6880<CopperHornInstrument>> optional = this.getInstrument(stack);
        return optional.map(copperHornInstrumentRegistryEntry -> ((CopperHornInstrument)copperHornInstrumentRegistryEntry.comp_349()).useDuration()).orElse(0);
    }

    private Optional<? extends class_6880<CopperHornInstrument>> getInstrument(class_1799 stack) {
        class_2960 identifier;
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound != null && (identifier = class_2960.method_12829((String)nbtCompound.method_10558(INSTRUMENT_KEY))) != null) {
            return GoatedCopperHornRegistries.INSTRUMENT.method_40264(class_5321.method_29179(GoatedCopperHornRegistries.INSTRUMENT_KEY, (class_2960)identifier));
        }
        Iterator iterator = GoatedCopperHornRegistries.INSTRUMENT.method_40286(this.instrumentTag).iterator();
        return iterator.hasNext() ? Optional.of((class_6880)iterator.next()) : Optional.empty();
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_39058;
    }

    private static void playSound(class_1937 world, class_1657 player, CopperHornInstrument instrument) {
        class_3414 soundEvent = instrument.melodySoundEvent();
        if ((double)player.method_36455() <= -30.0) {
            soundEvent = instrument.harmonySoundEvent();
        }
        if (player.method_5715()) {
            soundEvent = instrument.bassSoundEvent();
        }
        float f = instrument.range() / 16.0f;
        world.method_43129(player, (class_1297)player, soundEvent, class_3419.field_15247, f, 1.0f);
        world.method_32888(class_5712.field_39415, player.method_19538(), class_5712.class_7397.method_43285((class_1297)player));
    }

    private static void playSymphonySound(class_1937 world, class_1657 player, CopperHornInstrument instrument) {
        class_3414 melody = instrument.melodySoundEvent();
        class_3414 harmony = instrument.harmonySoundEvent();
        class_3414 bass = instrument.bassSoundEvent();
        float f = instrument.range() / 16.0f;
        world.method_43129(player, (class_1297)player, melody, class_3419.field_15247, f, 1.0f);
        world.method_43129(player, (class_1297)player, harmony, class_3419.field_15247, f, 1.0f);
        world.method_43129(player, (class_1297)player, bass, class_3419.field_15247, f, 1.0f);
        world.method_32888(class_5712.field_39415, player.method_19538(), class_5712.class_7397.method_43285((class_1297)player));
    }
}

