/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.event.custom;

import dev.ripio.cobbleloots.Cobbleloots;
import dev.ripio.cobbleloots.config.CobblelootsConfig;
import dev.ripio.cobbleloots.data.CobblelootsDataProvider;
import dev.ripio.cobbleloots.data.custom.CobblelootsLootBallData;
import dev.ripio.cobbleloots.entity.CobblelootsEntities;
import dev.ripio.cobbleloots.entity.custom.CobblelootsLootBall;
import dev.ripio.cobbleloots.util.CobblelootsDefinitions;
import dev.ripio.cobbleloots.util.enums.CobblelootsSourceType;
import dev.ripio.cobbleloots.util.search.CobblelootsSearch;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class CobblelootsLootBallEvents {
    private static final String TEXT_EVENT_LOOT_BALL_SPAWN_SPECIAL = "event.cobbleloots.loot_ball.spawn.special";

    public static boolean generateLootBallOnChunk(class_3218 level, class_2818 levelChunk, class_5819 randomSource) {
        if (randomSource.method_43057() > CobblelootsConfig.getFloatConfig("loot_ball.generation.chance")) {
            return false;
        }
        class_2826[] sections = levelChunk.method_12006();
        int sectionIndex = CobblelootsSearch.searchRandomNonEmptySectionIndex(sections, randomSource);
        if (sectionIndex < 0 || sectionIndex >= sections.length) {
            Cobbleloots.LOGGER.debug("[Cobbleloots] Invalid section index: {} for chunk at {}", (Object)sectionIndex, (Object)levelChunk.method_12004());
            return false;
        }
        class_2826 section = sections[sectionIndex];
        class_2338 relativePos = CobblelootsSearch.searchRandomValidLootBallSpawn(section, randomSource);
        if (relativePos == null) {
            return false;
        }
        class_2338 pos = relativePos.method_10069(levelChunk.method_12004().method_8326(), levelChunk.method_31604(sectionIndex) * 16, levelChunk.method_12004().method_8328());
        return CobblelootsLootBallEvents.spawnLootBall(level, levelChunk, pos, randomSource, CobblelootsSourceType.GENERATION) != null;
    }

    public static void spawnLootBallNearRandomPlayer(MinecraftServer server, class_5819 randomSource) {
        if (randomSource.method_43057() > CobblelootsConfig.getFloatConfig("loot_ball.spawning.chance")) {
            return;
        }
        List playerList = server.method_3760().method_14571();
        if (playerList.isEmpty()) {
            return;
        }
        class_3222 player = (class_3222)playerList.get(randomSource.method_43048(playerList.size()));
        class_3218 level = player.method_51469();
        class_2818 playerChunk = level.method_8500(player.method_24515());
        class_1923 playerChunkPos = playerChunk.method_12004();
        class_2818 randomChunk = level.method_8497(playerChunkPos.field_9181 + randomSource.method_39332(-1, 1), playerChunkPos.field_9180 + randomSource.method_39332(-1, 1));
        int sectionIndex = playerChunk.method_31602((int)player.method_23318());
        class_2826[] sections = randomChunk.method_12006();
        if (sectionIndex < 0 || sectionIndex >= sections.length) {
            Cobbleloots.LOGGER.debug("[Cobbleloots] Invalid section index: {} for player at {}", (Object)sectionIndex, (Object)player.method_24515());
            return;
        }
        class_2826 section = sections[sectionIndex];
        class_2338 relativePos = CobblelootsSearch.searchRandomValidLootBallSpawn(section, randomSource);
        if (relativePos == null) {
            return;
        }
        class_2338 pos = relativePos.method_10069(randomChunk.method_12004().method_8326(), randomChunk.method_31604(sectionIndex) * 16, randomChunk.method_12004().method_8328());
        CobblelootsLootBall lootBall = CobblelootsLootBallEvents.spawnLootBall(level, randomChunk, pos, randomSource, CobblelootsSourceType.SPAWNING);
        if (lootBall != null && CobblelootsConfig.getBooleanConfig("loot_ball.spawning.despawn.enabled")) {
            lootBall.setDespawnTick(level.method_8510() + (long)CobblelootsConfig.getIntConfig("loot_ball.spawning.despawn.time"));
        }
    }

    @Nullable
    private static CobblelootsLootBall spawnLootBall(class_3218 level, class_2818 chunk, class_2338 pos, class_5819 randomSource, CobblelootsSourceType sourceType) {
        class_1299<CobblelootsLootBall> lootBallEntityType;
        CobblelootsLootBall lootBall;
        ArrayList<String> variantKeys;
        Map.Entry<class_2960, CobblelootsLootBallData> lootBallEntry = CobblelootsDataProvider.getRandomLootBallData(level, chunk, pos, sourceType);
        if (lootBallEntry == null) {
            return null;
        }
        class_2960 dataId = lootBallEntry.getKey();
        CobblelootsLootBallData lootBallData = lootBallEntry.getValue();
        if (dataId == null || dataId == CobblelootsDefinitions.EMPTY_LOCATION) {
            return null;
        }
        String variant = "";
        if (lootBallData.getVariants() != null && !lootBallData.getVariants().isEmpty() && !(variantKeys = new ArrayList<String>(lootBallData.getVariants().keySet())).isEmpty()) {
            variant = (String)variantKeys.get(randomSource.method_43048(variantKeys.size()));
        }
        if ((lootBall = (CobblelootsLootBall)(lootBallEntityType = CobblelootsEntities.getLootBallEntityType()).method_5883((class_1937)level)) == null) {
            return null;
        }
        class_243 vec3 = new class_243((double)((float)pos.method_10263() + 0.25f + randomSource.method_43057() * 0.5f), (double)pos.method_10264(), (double)((float)pos.method_10260() + 0.25f + randomSource.method_43057() * 0.5f));
        float f = randomSource.method_43057() * 360.0f;
        lootBall.method_5808(vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), f, 0.0f);
        level.method_8649((class_1297)lootBall);
        lootBall.setLootBallDataId(dataId);
        lootBall.setVariantId(variant);
        if (CobblelootsConfig.getBooleanConfig("loot_ball.bonus.enabled") && randomSource.method_43057() < CobblelootsConfig.getFloatConfig("loot_ball.bonus.chance")) {
            lootBall.method_5648(CobblelootsConfig.getBooleanConfig("loot_ball.bonus.invisible"));
            lootBall.setMultiplier(CobblelootsConfig.getFloatConfig("loot_ball.bonus.multiplier"));
        }
        return lootBall;
    }
}

