/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.data.custom.filter;

import dev.ripio.cobbleloots.Cobbleloots;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class CobblelootsDateFilter {
    private final String from;
    private final String to;

    public CobblelootsDateFilter(String from, String to) {
        this.from = from;
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public boolean test() {
        boolean isToEmpty;
        boolean isFromEmpty = this.from == null || this.from.isEmpty();
        boolean bl = isToEmpty = this.to == null || this.to.isEmpty();
        if (isFromEmpty && isToEmpty) {
            return true;
        }
        try {
            MonthDay toDay;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM-dd");
            MonthDay currentDay = MonthDay.from(LocalDate.now());
            MonthDay fromDay = !isFromEmpty ? MonthDay.parse(this.from, formatter) : null;
            MonthDay monthDay = toDay = !isToEmpty ? MonthDay.parse(this.to, formatter) : null;
            if (fromDay != null && toDay != null) {
                if (fromDay.isAfter(toDay)) {
                    return !currentDay.isBefore(fromDay) || !currentDay.isAfter(toDay);
                }
                return !currentDay.isBefore(fromDay) && !currentDay.isAfter(toDay);
            }
            if (fromDay != null) {
                return !currentDay.isBefore(fromDay);
            }
            if (toDay != null) {
                return !currentDay.isAfter(toDay);
            }
            return true;
        }
        catch (DateTimeParseException e) {
            Cobbleloots.LOGGER.error("Invalid date format in date filter. Please use 'MM-dd'.", (Throwable)e);
            return false;
        }
    }
}

