/*
 * Decompiled with CFR 0.152.
 */
package me.pau.plugins.deathchest;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.pau.plugins.deathchest.handlers.Chests;
import me.pau.plugins.deathchest.handlers.Death;
import me.pau.plugins.deathchest.handlers.Interaction;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class DeathChest
extends JavaPlugin {
    public static DeathChest instance;
    private boolean isExcellentEnchantsEnabled = false;
    public static boolean playerBreakable;
    public static boolean dropItemsWhenBroken;
    public static boolean explosionProof;
    public static boolean dropItemsWhenExploded;
    public static boolean nameVisible;
    Death death;
    Interaction interaction;
    Chests chests;
    private final Map<Block, ChestMeta> chestMetaMap = new HashMap<Block, ChestMeta>();

    public void onEnable() {
        instance = this;
        DeathChest.infoPrint("I might be working");
        instance.saveDefaultConfig();
        playerBreakable = this.getConfig().getBoolean("chest_interactions.player_breakable", false);
        explosionProof = this.getConfig().getBoolean("chest_interactions.explosion_proof", true);
        dropItemsWhenExploded = this.getConfig().getBoolean("chest_interactions.items_drop_when_exploded", true);
        dropItemsWhenBroken = this.getConfig().getBoolean("chest_interactions.items_drop_when_broken", true);
        nameVisible = this.getConfig().getBoolean("chest_customization.name_on_chest", true);
        this.isExcellentEnchantsEnabled = this.getServer().getPluginManager().isPluginEnabled("ExcellentEnchants");
        this.chests = new Chests(instance);
        this.chests.load();
        for (Block block : this.chests.getAllBlocks()) {
            if (this.chestMetaMap.containsKey(block)) continue;
            this.chestMetaMap.put(block, new ChestMeta(null, null));
        }
        if (!this.chests.getAllBlocks().isEmpty()) {
            DeathChest.infoPrint("There are " + this.chests.getAllBlocks().size() + " death chests loaded in the world.");
        }
        this.death = new Death(instance, this.chests);
        this.interaction = new Interaction(instance, this.chests);
        this.chests.restoreInWorld();
        this.getCommand("deathchest").setExecutor((CommandExecutor)this);
    }

    public void registerDeathChest(Block block, UUID owner) {
        this.chestMetaMap.put(block, new ChestMeta(owner, Instant.now()));
    }

    public void unregisterDeathChest(Block block) {
        this.chestMetaMap.remove(block);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("[SimpleDeathChest] Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1 && args[0].equalsIgnoreCase("list")) {
            int i = 1;
            player.sendMessage("[SimpleDeathChest] Your death chests are at:");
            Instant now = Instant.now();
            for (Map.Entry<Block, ChestMeta> entry : this.chestMetaMap.entrySet()) {
                Block block = entry.getKey();
                ChestMeta meta = entry.getValue();
                if (meta.owner == null || meta.created == null) {
                    player.sendMessage(String.format("[SimpleDeathChest] %d. X:%d, Y:%d, Z:%d (unknown owner/time)", i++, block.getX(), block.getY(), block.getZ()));
                    continue;
                }
                if (!meta.owner.equals(player.getUniqueId())) continue;
                Duration duration = Duration.between(meta.created, now);
                String timeAgo = DeathChest.formatDuration(duration);
                player.sendMessage(String.format("[SimpleDeathChest] %d. X:%d, Y:%d, Z:%d (%s ago)", i++, block.getX(), block.getY(), block.getZ(), timeAgo));
            }
            if (i == 1) {
                player.sendMessage("[SimpleDeathChest] You have no active death chests.");
            }
            return true;
        }
        player.sendMessage("[SimpleDeathChest] Usage: /deathchest list");
        return true;
    }

    private static String formatDuration(Duration duration) {
        long days = duration.toDays();
        long hours = duration.toHours() % 24L;
        long minutes = duration.toMinutes() % 60L;
        if (days > 0L) {
            return String.format("%d day%s and %d minute%s", days, days == 1L ? "" : "s", minutes, minutes == 1L ? "" : "s");
        }
        if (hours > 0L) {
            return String.format("%d hour%s and %d minute%s", hours, hours == 1L ? "" : "s", minutes, minutes == 1L ? "" : "s");
        }
        return String.format("%d minute%s", minutes, minutes == 1L ? "" : "s");
    }

    public void onDisable() {
        this.chests.save();
        DeathChest.warnPrint("I'm def NOT working rn");
    }

    public static void infoPrint(String msg) {
        instance.getLogger().info(msg);
    }

    public static void warnPrint(String msg) {
        instance.getLogger().warning(msg);
    }

    public boolean isExcellentEnchantsEnabled() {
        return this.isExcellentEnchantsEnabled;
    }

    public static class ChestMeta {
        public final UUID owner;
        public final Instant created;

        public ChestMeta(UUID owner, Instant created) {
            this.owner = owner;
            this.created = created;
        }
    }
}

