/*
 * Decompiled with CFR 0.152.
 */
package me.pau.plugins.deathchest.handlers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import me.pau.plugins.deathchest.DeathChest;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class Chests {
    private final JavaPlugin plugin;
    private final HashMap<Block, Inventory> deathChests = new HashMap();

    public Set<Block> getAllBlocks() {
        return this.deathChests.keySet();
    }

    public Chests(DeathChest plugin) {
        this.plugin = plugin;
    }

    public void put(Block block, Inventory inventory) {
        this.deathChests.put(block, inventory);
    }

    public Inventory get(Block key) {
        return this.deathChests.get(key);
    }

    public Block get(Inventory value) {
        for (Block i : this.deathChests.keySet()) {
            if (this.deathChests.get(i) != value) continue;
            return i;
        }
        return null;
    }

    public boolean containsKey(Block key) {
        return this.deathChests.containsKey(key);
    }

    public boolean containsValue(Inventory value) {
        return this.deathChests.containsValue(value);
    }

    public void remove(Block key) {
        this.deathChests.remove(key);
    }

    private void deleteFile(File file) {
        YamlConfiguration emptyConfig = new YamlConfiguration();
        try {
            emptyConfig.save(file);
        }
        catch (IOException e) {
            DeathChest.warnPrint(e.toString());
        }
    }

    public void save() {
        File file = new File(this.plugin.getDataFolder(), "deathChests.yml");
        YamlConfiguration emptyConfig = new YamlConfiguration();
        try {
            emptyConfig.save(file);
        }
        catch (IOException e) {
            DeathChest.warnPrint(e.toString());
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (Block block : this.deathChests.keySet()) {
            String locString = block.getLocation().getWorld().getName() + "," + block.getX() + "," + block.getY() + "," + block.getZ();
            Inventory inventory = this.deathChests.get(block);
            config.set(locString, (Object)inventory.getContents());
        }
        try {
            config.save(file);
            DeathChest.infoPrint("Saving Death Chests");
        }
        catch (IOException e) {
            DeathChest.warnPrint(e.toString());
        }
    }

    public void load() {
        File file = new File(this.plugin.getDataFolder(), "deathChests.yml");
        if (file.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            for (String locString : config.getKeys(false)) {
                String[] locParts = locString.split(",");
                World world = Bukkit.getWorld((String)locParts[0]);
                int x = Integer.parseInt(locParts[1]);
                int y = Integer.parseInt(locParts[2]);
                int z = Integer.parseInt(locParts[3]);
                Location location = new Location(world, (double)x, (double)y, (double)z);
                Block block = location.getBlock();
                List contents = (List)config.get(locString);
                assert (contents != null);
                int chestInventorySize = Math.ceilDiv(contents.size(), 9) * 9;
                Inventory customInventory = Bukkit.createInventory(null, (int)chestInventorySize);
                customInventory.setContents(contents.toArray(new ItemStack[0]));
                this.deathChests.put(block, customInventory);
            }
        }
        this.deleteFile(file);
        DeathChest.infoPrint("Loaded Death Chests");
    }

    public void restoreInWorld() {
        for (Block chest : this.deathChests.keySet()) {
            if (chest != null && chest.getLocation().getChunk().isLoaded()) {
                chest.setType(Material.CHEST);
                continue;
            }
            assert (chest != null);
            DeathChest.warnPrint("Skipped restoring chest at unloaded chunk: " + String.valueOf(chest.getLocation()));
        }
    }
}

