/*
 * Decompiled with CFR 0.152.
 */
package me.pau.plugins.deathchest.handlers;

import java.util.Iterator;
import java.util.List;
import me.pau.plugins.deathchest.DeathChest;
import me.pau.plugins.deathchest.handlers.Chests;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Death
implements Listener {
    Chests deathChests;

    public Death(DeathChest plugin, Chests deathChests) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.deathChests = deathChests;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        List playerDrops = event.getDrops();
        if (playerDrops.isEmpty()) {
            return;
        }
        int chestInventorySize = Math.ceilDiv(playerDrops.size(), 9) * 9;
        Inventory customInventory = DeathChest.nameVisible ? Bukkit.createInventory(null, (int)chestInventorySize, (Component)Component.text((String)player.getName())) : Bukkit.createInventory(null, (int)chestInventorySize);
        Location chestLocation = new Location(player.getWorld(), player.getX(), player.getY() <= (double)player.getWorld().getMinHeight() ? (double)(player.getWorld().getMinHeight() + 1) : player.getY(), player.getZ());
        Block block = chestLocation.getBlock();
        if (block.getType() == Material.CHEST) {
            block = block.getRelative(BlockFace.UP);
        }
        block.setType(Material.CHEST);
        block.getState().update(true);
        DeathChest.instance.registerDeathChest(block, player.getUniqueId());
        if (DeathChest.instance.isExcellentEnchantsEnabled()) {
            Enchantment soulbound = Enchantment.getByKey((NamespacedKey)NamespacedKey.fromString((String)"minecraft:soulbound"));
            Iterator iterator = playerDrops.iterator();
            while (iterator.hasNext()) {
                ItemStack item = (ItemStack)iterator.next();
                if (item.getEnchantments().containsKey(soulbound)) continue;
                customInventory.addItem(new ItemStack[]{item});
                iterator.remove();
            }
        } else {
            for (ItemStack item : playerDrops) {
                customInventory.addItem(new ItemStack[]{item});
            }
            playerDrops.clear();
        }
        this.deathChests.put(block, customInventory);
        this.deathChests.save();
    }
}

