/*
 * Decompiled with CFR 0.152.
 */
package me.pau.plugins.deathchest.handlers;

import java.util.Optional;
import me.pau.plugins.deathchest.DeathChest;
import me.pau.plugins.deathchest.handlers.Chests;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Interaction
implements Listener {
    Chests deathChests;

    public Interaction(DeathChest plugin, Chests deathChests) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.deathChests = deathChests;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block brokenBlock = event.getBlock();
        if (!this.deathChests.containsKey(brokenBlock)) {
            return;
        }
        if (DeathChest.playerBreakable) {
            event.setDropItems(false);
            if (DeathChest.dropItemsWhenBroken) {
                this.dropItems(this.deathChests.get(brokenBlock).getContents(), brokenBlock.getLocation());
            }
            this.deathChests.remove(brokenBlock);
            return;
        }
        if (!this.deathChests.get(brokenBlock).isEmpty()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onChestOpen(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        if (clickedBlock.getType() != Material.CHEST) {
            return;
        }
        if (this.deathChests.containsKey(clickedBlock)) {
            Player player = event.getPlayer();
            player.openInventory(this.deathChests.get(clickedBlock));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onChestClose(InventoryCloseEvent event) {
        if (!this.deathChests.containsValue(event.getInventory())) {
            return;
        }
        if (!event.getInventory().isEmpty()) {
            return;
        }
        Block block = this.deathChests.get(event.getInventory());
        this.deathChests.remove(block);
        DeathChest.instance.unregisterDeathChest(block);
        block.setType(Material.AIR);
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        if (!DeathChest.explosionProof) {
            return;
        }
        event.blockList().removeIf(block -> block.getType() == Material.CHEST && this.deathChests.containsKey((Block)block));
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        Optional<Block> chestOptional = event.blockList().stream().filter(block -> block.getType() == Material.CHEST && this.deathChests.containsKey((Block)block)).findFirst();
        if (chestOptional.isEmpty()) {
            return;
        }
        Block chest = chestOptional.get();
        event.blockList().remove(chest);
        if (!DeathChest.explosionProof) {
            if (DeathChest.dropItemsWhenExploded) {
                this.dropItems(this.deathChests.get(chest).getContents(), chest.getLocation());
            }
            this.deathChests.remove(chest);
            chest.setType(Material.AIR);
        }
    }

    public void dropItems(ItemStack[] items, Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        for (ItemStack item : items) {
            if (item == null || item.getAmount() <= 0) continue;
            world.dropItemNaturally(location, item);
        }
    }
}

