/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.client.IObjectPicker;
import com.github.exopandora.shouldersurfing.api.model.Couple;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ObjectPicker
implements IObjectPicker {
    @Override
    public HitResult pick(PickContext context, double interactionRangeOverride, float partialTick, MultiPlayerGameMode gameMode) {
        double distance;
        EntityHitResult entityHit;
        double interactionRange = Math.max((double)gameMode.m_105286_(), interactionRangeOverride);
        BlockHitResult blockHit = this.pickBlocks(context, interactionRange, partialTick);
        Vec3 eyePosition = context.entity().m_20299_(partialTick);
        if (gameMode.m_105291_()) {
            interactionRange = Math.max(interactionRange, 6.0);
        }
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            interactionRange = blockHit.m_82450_().m_82554_(eyePosition);
        }
        if ((entityHit = this.pickEntities(context, interactionRange, partialTick)) != null && ((distance = eyePosition.m_82554_(entityHit.m_82450_())) < interactionRange || blockHit.m_6662_() != HitResult.Type.MISS)) {
            return entityHit;
        }
        return blockHit;
    }

    @Override
    public EntityHitResult pickEntities(PickContext context, double interactionRange, float partialTick) {
        Vec3 viewVector = new Vec3(context.camera().m_90596_()).m_82490_(interactionRange);
        AABB aabb = context.entity().m_20191_().m_82369_(viewVector).m_82377_(1.0, 1.0, 1.0);
        Couple<Vec3> entityRay = context.entityTrace(interactionRange, partialTick);
        double interactionRangeSq = entityRay.left().m_82557_(entityRay.right());
        return ProjectileUtil.m_37287_((Entity)context.entity(), (Vec3)entityRay.left(), (Vec3)entityRay.right(), (AABB)aabb, context.entityFilter(), (double)interactionRangeSq);
    }

    @Override
    public BlockHitResult pickBlocks(PickContext context, double interactionRange, float partialTick) {
        return context.entity().f_19853_.m_45547_(context.toClipContext(interactionRange, partialTick));
    }
}

