/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.config;

import com.github.exopandora.shouldersurfing.api.client.IClientConfig;
import com.github.exopandora.shouldersurfing.api.model.CrosshairType;
import com.github.exopandora.shouldersurfing.api.model.CrosshairVisibility;
import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.api.model.PickOrigin;
import com.github.exopandora.shouldersurfing.api.model.PickVector;
import com.github.exopandora.shouldersurfing.api.model.TurningMode;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.mixins.ResourceLocationAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;

    protected static <T> void set(ForgeConfigSpec.ConfigValue<T> configValue, T value) {
        if (value != null && !value.equals(configValue.get())) {
            configValue.set(value);
        }
    }

    public static void onConfigReload() {
        Perspective currentPerspective = Perspective.current();
        ShoulderSurfingImpl instance = ShoulderSurfingImpl.getInstance();
        if (!(currentPerspective.isEnabled(CLIENT) || currentPerspective == Perspective.FIRST_PERSON && instance.isTemporaryFirstPerson())) {
            instance.changePerspective(currentPerspective.next(CLIENT));
        }
        if (CLIENT.doRememberLastPerspective()) {
            CLIENT.setDefaultPerspective(Perspective.current());
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        CLIENT = (ClientConfig)pair.getLeft();
    }

    public static class ClientConfig
    implements IClientConfig {
        private final ForgeConfigSpec.DoubleValue offsetX;
        private final ForgeConfigSpec.DoubleValue offsetY;
        private final ForgeConfigSpec.DoubleValue offsetZ;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> offsetXPresets;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> offsetYPresets;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> offsetZPresets;
        private final ForgeConfigSpec.DoubleValue minOffsetX;
        private final ForgeConfigSpec.DoubleValue minOffsetY;
        private final ForgeConfigSpec.DoubleValue minOffsetZ;
        private final ForgeConfigSpec.DoubleValue maxOffsetX;
        private final ForgeConfigSpec.DoubleValue maxOffsetY;
        private final ForgeConfigSpec.DoubleValue maxOffsetZ;
        private final ForgeConfigSpec.BooleanValue unlimitedOffsetX;
        private final ForgeConfigSpec.BooleanValue unlimitedOffsetY;
        private final ForgeConfigSpec.BooleanValue unlimitedOffsetZ;
        private final ForgeConfigSpec.DoubleValue passengerOffsetXMultiplier;
        private final ForgeConfigSpec.DoubleValue passengerOffsetYMultiplier;
        private final ForgeConfigSpec.DoubleValue passengerOffsetZMultiplier;
        private final ForgeConfigSpec.DoubleValue sprintOffsetXMultiplier;
        private final ForgeConfigSpec.DoubleValue sprintOffsetYMultiplier;
        private final ForgeConfigSpec.DoubleValue sprintOffsetZMultiplier;
        private final ForgeConfigSpec.DoubleValue aimingOffsetXMultiplier;
        private final ForgeConfigSpec.DoubleValue aimingOffsetYMultiplier;
        private final ForgeConfigSpec.DoubleValue aimingOffsetZMultiplier;
        private final ForgeConfigSpec.DoubleValue fallFlyingOffsetXMultiplier;
        private final ForgeConfigSpec.DoubleValue fallFlyingOffsetYMultiplier;
        private final ForgeConfigSpec.DoubleValue fallFlyingOffsetZMultiplier;
        private final ForgeConfigSpec.DoubleValue climbingOffsetXMultiplier;
        private final ForgeConfigSpec.DoubleValue climbingOffsetYMultiplier;
        private final ForgeConfigSpec.DoubleValue climbingOffsetZMultiplier;
        private final ForgeConfigSpec.DoubleValue passengerOffsetXModifier;
        private final ForgeConfigSpec.DoubleValue passengerOffsetYModifier;
        private final ForgeConfigSpec.DoubleValue passengerOffsetZModifier;
        private final ForgeConfigSpec.DoubleValue sprintOffsetXModifier;
        private final ForgeConfigSpec.DoubleValue sprintOffsetYModifier;
        private final ForgeConfigSpec.DoubleValue sprintOffsetZModifier;
        private final ForgeConfigSpec.DoubleValue aimingOffsetXModifier;
        private final ForgeConfigSpec.DoubleValue aimingOffsetYModifier;
        private final ForgeConfigSpec.DoubleValue aimingOffsetZModifier;
        private final ForgeConfigSpec.DoubleValue fallFlyingOffsetXModifier;
        private final ForgeConfigSpec.DoubleValue fallFlyingOffsetYModifier;
        private final ForgeConfigSpec.DoubleValue fallFlyingOffsetZModifier;
        private final ForgeConfigSpec.DoubleValue climbingOffsetXModifier;
        private final ForgeConfigSpec.DoubleValue climbingOffsetYModifier;
        private final ForgeConfigSpec.DoubleValue climbingOffsetZModifier;
        private final ForgeConfigSpec.DoubleValue keepCameraOutOfHeadMultiplier;
        private final ForgeConfigSpec.DoubleValue cameraStepSize;
        private final ForgeConfigSpec.DoubleValue cameraTransitionSpeedMultiplier;
        private final ForgeConfigSpec.DoubleValue centerCameraWhenLookingDownAngle;
        private final ForgeConfigSpec.BooleanValue dynamicallyAdjustOffsets;
        private final ForgeConfigSpec.BooleanValue isCameraDecoupled;
        private final ForgeConfigSpec.BooleanValue orientCameraOnTeleport;
        private final ForgeConfigSpec.BooleanValue isFovOverrideEnabled;
        private final ForgeConfigSpec.DoubleValue fovOverride;
        private final ForgeConfigSpec.DoubleValue cameraDragXMultiplier;
        private final ForgeConfigSpec.DoubleValue cameraDragYMultiplier;
        private final ForgeConfigSpec.DoubleValue cameraDragZMultiplier;
        private final ForgeConfigSpec.DoubleValue cameraSwayXMaxAngle;
        private final ForgeConfigSpec.DoubleValue cameraSwayZMaxAngle;
        private final ForgeConfigSpec.DoubleValue cameraSwayXMaxVelocity;
        private final ForgeConfigSpec.DoubleValue cameraSwayZMaxVelocity;
        private final ForgeConfigSpec.BooleanValue replaceDefaultPerspective;
        private final ForgeConfigSpec.BooleanValue isFirstPersonEnabled;
        private final ForgeConfigSpec.BooleanValue isThirdPersonFrontEnabled;
        private final ForgeConfigSpec.BooleanValue isThirdPersonBackEnabled;
        private final ForgeConfigSpec.ConfigValue<Perspective> defaultPerspective;
        private final ForgeConfigSpec.BooleanValue rememberLastPerspective;
        private final ForgeConfigSpec.BooleanValue playerTransparency;
        private final ForgeConfigSpec.BooleanValue turnPlayerTransparentWhenAiming;
        private final ForgeConfigSpec.DoubleValue hidePlayerWhenLookingUpAngle;
        private final ForgeConfigSpec.ConfigValue<TurningMode> turningModeWhenUsingItem;
        private final ForgeConfigSpec.ConfigValue<TurningMode> turningModeWhenAttacking;
        private final ForgeConfigSpec.ConfigValue<TurningMode> turningModeWhenInteraction;
        private final ForgeConfigSpec.ConfigValue<TurningMode> turningModeWhenPicking;
        private final ForgeConfigSpec.IntValue turningLockTime;
        private final ForgeConfigSpec.BooleanValue playerXRotFollowsCamera;
        private final ForgeConfigSpec.BooleanValue playerYRotFollowsCamera;
        private final ForgeConfigSpec.DoubleValue playerYRotFollowAngleLimit;
        private final ForgeConfigSpec.ConfigValue<PickOrigin> entityPickOrigin;
        private final ForgeConfigSpec.ConfigValue<PickOrigin> blockPickOrigin;
        private final ForgeConfigSpec.ConfigValue<PickVector> pickVector;
        private final ForgeConfigSpec.ConfigValue<CrosshairType> crosshairType;
        private final ForgeConfigSpec.DoubleValue customRaytraceDistance;
        private final ForgeConfigSpec.BooleanValue useCustomRaytraceDistance;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> adaptiveCrosshairHoldItems;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> adaptiveCrosshairUseItems;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> adaptiveCrosshairHoldItemProperties;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> adaptiveCrosshairUseItemProperties;
        private final Map<Perspective, ForgeConfigSpec.ConfigValue<CrosshairVisibility>> crosshairVisibility = new HashMap<Perspective, ForgeConfigSpec.ConfigValue<CrosshairVisibility>>();
        private final ForgeConfigSpec.BooleanValue showObstructionIndicator;
        private final ForgeConfigSpec.BooleanValue showObstructionIndicatorWhenAiming;
        private final ForgeConfigSpec.IntValue obstructionIndicatorMinDistanceToCrosshair;
        private final ForgeConfigSpec.DoubleValue obstructionIndicatorMaxDistanceToObstruction;
        private final ForgeConfigSpec.BooleanValue centerPlayerSounds;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> curiosAdaptiveCrosshairItems;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> curiosAdaptiveCrosshairItemProperties;
        private final ForgeConfigSpec.BooleanValue epicFightDecoupledCameraLockOn;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("camera");
            builder.push("offset");
            this.offsetX = builder.comment("Third person camera x-offset.").translation("shouldersurfing.configuration.camera.offset.offset_x").defineInRange("offset_x", -0.75, -1.7976931348623157E308, Double.MAX_VALUE);
            this.offsetY = builder.comment("Third person camera y-offset.").translation("shouldersurfing.configuration.camera.offset.offset_y").defineInRange("offset_y", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.offsetZ = builder.comment("Third person camera z-offset.").translation("shouldersurfing.configuration.camera.offset.offset_z").defineInRange("offset_z", 4.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.push("presets");
            this.offsetXPresets = builder.comment("A list of x-offset presets that can be toggled via the 'Toggle X-Offset Presets' keybind. WARNING: Duplicate entries can result in undefined behavior!").translation("shouldersurfing.configuration.offset.presets.offset_x_presets").defineList("presets_offset_x", ArrayList::new, ClientConfig::isValidDouble);
            this.offsetYPresets = builder.comment("A list of y-offset presets that can be toggled via the 'Toggle Y-Offset Presets' keybind. WARNING: Duplicate entries can result in undefined behavior!").translation("shouldersurfing.configuration.offset.presets.offset_y_presets").defineList("presets_offset_y", ArrayList::new, ClientConfig::isValidDouble);
            this.offsetZPresets = builder.comment("A list of z-offset presets that can be toggled via the 'Toggle Z-Offset Presets' keybind. WARNING: Duplicate entries can result in undefined behavior!").translation("shouldersurfing.configuration.offset.presets.offset_z_presets").defineList("presets_offset_z", ArrayList::new, ClientConfig::isValidDouble);
            builder.pop();
            builder.push("min");
            this.minOffsetX = builder.comment("When x-offset is limited this is the minimum amount.").translation("shouldersurfing.configuration.offset.min.min_offset_x").defineInRange("min_offset_x", -3.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.minOffsetY = builder.comment("When y-offset is limited this is the minimum amount.").translation("shouldersurfing.configuration.offset.min.min_offset_y").defineInRange("min_offset_y", -1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.minOffsetZ = builder.comment("When z-offset is limited this is the minimum amount.").translation("shouldersurfing.configuration.offset.min.min_offset_z").defineInRange("min_offset_z", -3.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
            builder.push("max");
            this.maxOffsetX = builder.comment("When x-offset is limited this is the maximum amount.").translation("shouldersurfing.configuration.offset.max.max_offset_x").defineInRange("max_offset_x", 3.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.maxOffsetY = builder.comment("When y-offset is limited this is the maximum amount.").translation("shouldersurfing.configuration.offset.max.max_offset_y").defineInRange("max_offset_y", 1.5, -1.7976931348623157E308, Double.MAX_VALUE);
            this.maxOffsetZ = builder.comment("When z-offset is limited this is the maximum amount.").translation("shouldersurfing.configuration.offset.max.max_offset_z").defineInRange("max_offset_z", 5.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
            builder.push("limits");
            this.unlimitedOffsetX = builder.comment("Whether or not x-offset adjustment has limits.").translation("shouldersurfing.configuration.offset.limits.unlimited_offset_x").define("unlimited_offset_x", false);
            this.unlimitedOffsetY = builder.comment("Whether or not y-offset adjustment has limits.").translation("shouldersurfing.configuration.offset.limits.unlimited_offset_y").define("unlimited_offset_y", false);
            this.unlimitedOffsetZ = builder.comment("Whether or not z-offset adjustment has limits.").translation("shouldersurfing.configuration.offset.limits.unlimited_offset_z").define("unlimited_offset_z", false);
            builder.pop();
            builder.push("multiplier");
            builder.push("passenger");
            this.passengerOffsetXMultiplier = builder.comment("x-offset multiplier for when the player is a passenger.").translation("shouldersurfing.configuration.offset.multiplier.passenger.multiplier_offset_x").defineInRange("multiplier_offset_x", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.passengerOffsetYMultiplier = builder.comment("y-offset multiplier for when the player is a passenger.").translation("shouldersurfing.configuration.offset.multiplier.passenger.multiplier_offset_y").defineInRange("multiplier_offset_y", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.passengerOffsetZMultiplier = builder.comment("z-offset multiplier for when the player is a passenger.").translation("shouldersurfing.configuration.offset.multiplier.passenger.multiplier_offset_z").defineInRange("multiplier_offset_z", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
            builder.push("sprint");
            this.sprintOffsetXMultiplier = builder.comment("x-offset multiplier for when the player is sprinting.").translation("shouldersurfing.configuration.offset.multiplier.sprint.multiplier_offset_x").defineInRange("multiplier_offset_x", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.sprintOffsetYMultiplier = builder.comment("y-offset multiplier for when the player is sprinting.").translation("shouldersurfing.configuration.offset.multiplier.sprint.multiplier_offset_y").defineInRange("multiplier_offset_y", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.sprintOffsetZMultiplier = builder.comment("z-offset multiplier for when the player is sprinting.").translation("shouldersurfing.configuration.offset.multiplier.sprint.multiplier_offset_z").defineInRange("multiplier_offset_z", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
            builder.push("aiming");
            this.aimingOffsetXMultiplier = builder.comment("x-offset multiplier for when the player is aiming.").translation("shouldersurfing.configuration.offset.multiplier.aiming.multiplier_offset_x").defineInRange("multiplier_offset_x", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.aimingOffsetYMultiplier = builder.comment("y-offset multiplier for when the player is aiming.").translation("shouldersurfing.configuration.offset.multiplier.aiming.multiplier_offset_y").defineInRange("multiplier_offset_y", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.aimingOffsetZMultiplier = builder.comment("z-offset multiplier for when the player is aiming.").translation("shouldersurfing.configuration.offset.multiplier.aiming.multiplier_offset_z").defineInRange("multiplier_offset_z", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
            builder.push("fall_flying");
            this.fallFlyingOffsetXMultiplier = builder.comment("x-offset multiplier for when using Elytra.").translation("shouldersurfing.configuration.offset.multiplier.fall_flying.multiplier_offset_x").defineInRange("multiplier_offset_x", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.fallFlyingOffsetYMultiplier = builder.comment("y-offset multiplier for when using Elytra.").translation("shouldersurfing.configuration.offset.multiplier.fall_flying.multiplier_offset_y").defineInRange("multiplier_offset_y", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.fallFlyingOffsetZMultiplier = builder.comment("z-offset multiplier for when using Elytra.").translation("shouldersurfing.configuration.offset.multiplier.fall_flying.multiplier_offset_z").defineInRange("multiplier_offset_z", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
            builder.push("climbing");
            this.climbingOffsetXMultiplier = builder.comment("x-offset multiplier for when the player is climbing.").translation("shouldersurfing.configuration.offset.multiplier.climbing.multiplier_offset_x").defineInRange("multiplier_offset_x", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.climbingOffsetYMultiplier = builder.comment("y-offset multiplier for when the player is climbing.").translation("shouldersurfing.configuration.offset.multiplier.climbing.multiplier_offset_y").defineInRange("multiplier_offset_y", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.climbingOffsetZMultiplier = builder.comment("z-offset multiplier for when the player is climbing.").translation("shouldersurfing.configuration.offset.multiplier.climbing.multiplier_offset_z").defineInRange("multiplier_offset_z", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.push("modifiers");
            builder.push("passenger");
            this.passengerOffsetXModifier = builder.comment("x-offset modifier for when the player is a passenger.").translation("shouldersurfing.configuration.offset.modifier.passenger.modifier_offset_x").defineInRange("modifier_offset_x", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.passengerOffsetYModifier = builder.comment("y-offset modifier for when the player is a passenger.").translation("shouldersurfing.configuration.offset.modifier.passenger.modifier_offset_y").defineInRange("modifier_offset_y", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.passengerOffsetZModifier = builder.comment("z-offset modifier for when the player is a passenger.").translation("shouldersurfing.configuration.offset.modifier.passenger.modifier_offset_z").defineInRange("modifier_offset_z", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
            builder.push("sprint");
            this.sprintOffsetXModifier = builder.comment("x-offset modifier for when the player is sprinting.").translation("shouldersurfing.configuration.offset.modifier.sprint.modifier_offset_x").defineInRange("modifier_offset_x", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.sprintOffsetYModifier = builder.comment("y-offset modifier for when the player is sprinting.").translation("shouldersurfing.configuration.offset.modifier.sprint.modifier_offset_y").defineInRange("modifier_offset_y", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.sprintOffsetZModifier = builder.comment("z-offset modifier for when the player is sprinting.").translation("shouldersurfing.configuration.offset.modifier.sprint.modifier_offset_z").defineInRange("modifier_offset_z", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
            builder.push("aiming");
            this.aimingOffsetXModifier = builder.comment("x-offset modifier for when the player is aiming.").translation("shouldersurfing.configuration.offset.modifier.aiming.modifier_offset_x").defineInRange("modifier_offset_x", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.aimingOffsetYModifier = builder.comment("y-offset modifier for when the player is aiming.").translation("shouldersurfing.configuration.offset.modifier.aiming.modifier_offset_y").defineInRange("modifier_offset_y", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.aimingOffsetZModifier = builder.comment("z-offset modifier for when the player is aiming.").translation("shouldersurfing.configuration.offset.modifier.aiming.modifier_offset_z").defineInRange("modifier_offset_z", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
            builder.push("fall_flying");
            this.fallFlyingOffsetXModifier = builder.comment("x-offset modifier for when using Elytra.").translation("shouldersurfing.configuration.offset.modifier.fall_flying.modifier_offset_x").defineInRange("modifier_offset_x", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.fallFlyingOffsetYModifier = builder.comment("y-offset modifier for when using Elytra.").translation("shouldersurfing.configuration.offset.modifier.fall_flying.modifier_offset_y").defineInRange("modifier_offset_y", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.fallFlyingOffsetZModifier = builder.comment("z-offset modifier for when using Elytra.").translation("shouldersurfing.configuration.offset.modifier.fall_flying.modifier_offset_z").defineInRange("modifier_offset_z", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
            builder.push("climbing");
            this.climbingOffsetXModifier = builder.comment("x-offset modifier for when the player is climbing.").translation("shouldersurfing.configuration.offset.modifier.climbing.modifier_offset_x").defineInRange("modifier_offset_x", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.climbingOffsetYModifier = builder.comment("y-offset modifier for when the player is climbing.").translation("shouldersurfing.configuration.offset.modifier.climbing.modifier_offset_y").defineInRange("modifier_offset_y", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.climbingOffsetZModifier = builder.comment("z-offset modifier for when the player is climbing.").translation("shouldersurfing.configuration.offset.modifier.climbing.modifier_offset_z").defineInRange("modifier_offset_z", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.pop();
            this.keepCameraOutOfHeadMultiplier = builder.comment("The distance multiplier on whether or not to hide the player model if the camera gets too close to it. Set to 0 to disable.").translation("shouldersurfing.configuration.camera.keep_camera_out_of_head_distance_multiplier").defineInRange("keep_camera_out_of_head_distance_multiplier", 0.75, 0.0, Double.MAX_VALUE);
            this.cameraStepSize = builder.comment("Size of the camera adjustment per step.").translation("shouldersurfing.configuration.camera.camera_step_size").defineInRange("camera_step_size", 0.025, -1.7976931348623157E308, Double.MAX_VALUE);
            this.cameraTransitionSpeedMultiplier = builder.comment("The speed multiplier at which the camera transitions between positions.").translation("shouldersurfing.configuration.camera.camera_transition_speed_multiplier").defineInRange("camera_transition_speed_multiplier", 0.25, 0.05, 1.0);
            this.centerCameraWhenLookingDownAngle = builder.comment("The angle at which the camera will be centered when looking down. Set to 0 to disable.").translation("shouldersurfing.configuration.camera.center_camera_when_looking_down_angle").defineInRange("center_camera_when_looking_down_angle", 1.0, 0.0, 90.0);
            this.dynamicallyAdjustOffsets = builder.comment("Whether or not to dynamically adjust camera offsets depending on space constraints.").translation("shouldersurfing.configuration.camera.dynamically_adjust_offsets").define("dynamically_adjust_offsets", true);
            this.isCameraDecoupled = builder.comment("Whether or not to decouple the camera rotation from the player rotation.").translation("shouldersurfing.configuration.camera.decoupled_camera").define("decoupled_camera", true);
            this.orientCameraOnTeleport = builder.comment("Whether or not to orient the camera rotation when the player is teleported. This includes passenger (dis-)mounting and traveling through portals.").translation("shouldersurfing.configuration.camera.orient_camera_on_teleport").define("orient_camera_on_teleport", true);
            this.isFovOverrideEnabled = builder.comment("Whether or not to apply the FOV override when in shoulder surfing perspective.").translation("shouldersurfing.configuration.camera.fov_override_enabled").define("fov_override_enabled", false);
            this.fovOverride = builder.comment("The camera FOV when in shoulder surfing perspective. Depends on config option 'fov_override_enabled'.").translation("shouldersurfing.configuration.camera.fov_override").defineInRange("fov_override", 70.0, 30.0, 110.0);
            builder.push("camera_drag");
            this.cameraDragXMultiplier = builder.comment("x-axis multiplier for camera drag.").translation("shouldersurfing.configuration.camera.camera_drag.multiplier_axis_x").defineInRange("multiplier_axis_x", 0.0, 0.0, 5.0);
            this.cameraDragYMultiplier = builder.comment("y-axis multiplier for camera drag.").translation("shouldersurfing.configuration.camera.camera_drag.multiplier_axis_y").defineInRange("multiplier_axis_y", 0.0, 0.0, 5.0);
            this.cameraDragZMultiplier = builder.comment("z-axis multiplier for camera drag.").translation("shouldersurfing.configuration.camera.camera_drag.multiplier_axis_z").defineInRange("multiplier_axis_z", 0.0, 0.0, 5.0);
            builder.pop();
            builder.push("camera_sway");
            this.cameraSwayXMaxAngle = builder.comment("The maximum x-axis angle in degrees. Set to 0 to disable.").translation("shouldersurfing.configuration.camera.camera_sway.max_angle_axis_x").defineInRange("max_angle_axis_x", 0.0, -30.0, 30.0);
            this.cameraSwayZMaxAngle = builder.comment("The maximum x-axis angle in degrees. Set to 0 to disable.").translation("shouldersurfing.configuration.camera.camera_sway.max_angle_axis_z").defineInRange("max_angle_axis_z", 0.0, -30.0, 30.0);
            this.cameraSwayXMaxVelocity = builder.comment("The velocity of the player in blocks per second, where the maximum camera x-axis sway is applied.").translation("shouldersurfing.configuration.camera.camera_sway.max_velocity_axis_x").defineInRange("max_velocity_axis_x", 5.0, 0.05, 1000.0);
            this.cameraSwayZMaxVelocity = builder.comment("The velocity of the player in blocks per second, where the maximum camera z-axis sway is applied.").translation("shouldersurfing.configuration.camera.camera_sway.max_velocity_axis_z").defineInRange("max_velocity_axis_z", 5.0, 0.05, 1000.0);
            builder.pop();
            builder.pop();
            builder.push("perspective");
            this.defaultPerspective = builder.comment("The default perspective when you load the game.").translation("shouldersurfing.configuration.perspective.default_perspective").defineEnum("default_perspective", (Enum)Perspective.SHOULDER_SURFING, (Enum[])Perspective.values());
            this.rememberLastPerspective = builder.comment("Whether or not to remember the last perspective used.").translation("shouldersurfing.configuration.perspective.remember_last_perspective").define("remember_last_perspective", true);
            this.replaceDefaultPerspective = builder.comment("Whether or not to replace the default third person perspective.").translation("shouldersurfing.configuration.perspective.replace_default_perspective").define("replace_default_perspective", false);
            this.isFirstPersonEnabled = builder.comment("Whether or not the first person perspective is enabled.").translation("shouldersurfing.configuration.perspective.first_person_enabled").define("first_person_enabled", true);
            this.isThirdPersonFrontEnabled = builder.comment("Whether or not the third person front perspective is enabled.").translation("shouldersurfing.configuration.perspective.third_person_front_enabled").define("third_person_front_enabled", true);
            this.isThirdPersonBackEnabled = builder.comment("Whether or not the third person back perspective is enabled.").translation("shouldersurfing.configuration.perspective.third_person_back_enabled").define("third_person_back_enabled", true);
            builder.pop();
            builder.push("player");
            this.playerTransparency = builder.comment("Whether or not to adjust the player model transparency when view is obstructed. Changing this value may require a game restart to take full effect.").translation("shouldersurfing.configuration.player.adjust_player_transparency").define("adjust_player_transparency", true);
            this.turnPlayerTransparentWhenAiming = builder.comment("Whether or not to turn the player model transparent when aiming. This config option only applies when adjust player transparency is enabled.").translation("shouldersurfing.configuration.player.turn_player_transparent_when_aiming").define("turn_player_transparent_when_aiming", false);
            this.hidePlayerWhenLookingUpAngle = builder.comment("The angle at which the player will no longer be rendered when looking up. Set to 0 to disable.").translation("shouldersurfing.configuration.player.hide_player_when_looking_up_angle").defineInRange("hide_player_when_looking_up_angle", 0.0, 0.0, 90.0);
            this.playerXRotFollowsCamera = builder.comment("Whether the x-rot of the player should follow the camera x-rot. This config option only applies when camera is decoupled.").translation("shouldersurfing.configuration.player.player_x_rot_follows_camera").define("player_x_rot_follows_camera", false);
            this.playerYRotFollowsCamera = builder.comment("Whether the y-rot of the player should follow the camera y-rot. This config option only applies when camera is decoupled.").translation("shouldersurfing.configuration.player.player_y_rot_follows_camera").define("player_y_rot_follows_camera", false);
            this.playerYRotFollowAngleLimit = builder.comment("The maximum angle to which the player y-rot follows the camera y-rot. This config option only applies when player y-rot follows camera option is enabled.").translation("shouldersurfing.configuration.player.player_y_rot_follow_angle_limit").defineInRange("player_y_rot_follow_angle_limit", 90.0, 0.0, 180.0);
            builder.push("turning");
            this.turningModeWhenUsingItem = builder.comment("Whether to turn the player when using an item. This config option only applies when camera is decoupled.").translation("shouldersurfing.configuration.player.turning.when_using_item").defineEnum("when_using_item", (Enum)TurningMode.ALWAYS, (Enum[])TurningMode.values());
            this.turningModeWhenAttacking = builder.comment("Whether to turn the player when attacking. This config option only applies when camera is decoupled.").translation("shouldersurfing.configuration.player.turning.when_attacking").defineEnum("when_attacking", (Enum)TurningMode.REQUIRES_TARGET, (Enum[])TurningMode.values());
            this.turningModeWhenInteraction = builder.comment("Whether to turn the player when interacting with blocks. This config option only applies when camera is decoupled.").translation("shouldersurfing.configuration.player.turning.when_interacting").defineEnum("when_interacting", (Enum)TurningMode.ALWAYS, (Enum[])TurningMode.values());
            this.turningModeWhenPicking = builder.comment("Whether to turn the player when picking blocks or entities. This config option only applies when camera is decoupled.").translation("shouldersurfing.configuration.player.turning.when_picking").defineEnum("when_picking", (Enum)TurningMode.ALWAYS, (Enum[])TurningMode.values());
            this.turningLockTime = builder.comment("The time in ticks the player will remain turned after the interaction has ended. Set to 0 to disable. This config option only applies when camera is decoupled.").translation("shouldersurfing.configuration.player.turning.turning_lock_time").defineInRange("turning_lock_time", 4, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.push("object_picker");
            this.customRaytraceDistance = builder.comment("The raytrace distance used for the dynamic crosshair.").translation("shouldersurfing.configuration.object_picker.custom_raytrace_distance").defineInRange("custom_raytrace_distance", 400.0, 0.0, Double.MAX_VALUE);
            this.useCustomRaytraceDistance = builder.comment("Whether or not to use the custom raytrace distance used for the dynamic crosshair.").translation("shouldersurfing.configuration.object_picker.use_custom_raytrace_distance").define("use_custom_raytrace_distance", true);
            builder.push("pick_origin");
            this.entityPickOrigin = builder.comment("The origin where the entity pick starts when using the static crosshair.").translation("shouldersurfing.configuration.object_picker.pick_origin.entity_pick_origin").defineEnum("entity_pick_origin", (Enum)PickOrigin.PLAYER, (Enum[])PickOrigin.values());
            this.blockPickOrigin = builder.comment("The origin where the block pick starts when using the static crosshair.").translation("shouldersurfing.configuration.object_picker.pick_origin.block_pick_origin").defineEnum("block_pick_origin", (Enum)PickOrigin.PLAYER, (Enum[])PickOrigin.values());
            builder.pop();
            builder.push("pick_vector");
            this.pickVector = builder.comment("The vector direction of the raytrace when picking objects. This config option only applies when using the dynamic crosshair.").translation("shouldersurfing.configuration.object_picker.pick_vector.pick_vector").defineEnum("pick_vector", (Enum)PickVector.CAMERA, (Enum[])PickVector.values());
            builder.pop();
            builder.pop();
            builder.push("crosshair");
            this.crosshairType = builder.comment("Crosshair type to use for shoulder surfing.").translation("shouldersurfing.configuration.crosshair.crosshair_type").defineEnum("crosshair_type", (Enum)CrosshairType.STATIC, (Enum[])CrosshairType.values());
            this.adaptiveCrosshairHoldItems = builder.comment("Items that when held, trigger the dynamic crosshair in adaptive mode. This config option supports regular expressions. Example: 'minecraft:.*sword' matches 'minecraft:wooden_sword' and 'minecraft:netherite_sword'.").translation("shouldersurfing.configuration.crosshair.adaptive_crosshair_hold_items").defineList("adaptive_crosshair_hold_items", () -> {
                ArrayList<String> items = new ArrayList<String>();
                items.add(Registry.f_122827_.m_7981_((Object)Items.f_42452_).toString());
                items.add(Registry.f_122827_.m_7981_((Object)Items.f_42521_).toString());
                items.add(Registry.f_122827_.m_7981_((Object)Items.f_42612_).toString());
                items.add(Registry.f_122827_.m_7981_((Object)Items.f_42584_).toString());
                items.add(Registry.f_122827_.m_7981_((Object)Items.f_42736_).toString());
                items.add(Registry.f_122827_.m_7981_((Object)Items.f_42523_).toString());
                items.add(Registry.f_122827_.m_7981_((Object)Items.f_42739_).toString());
                return items;
            }, Objects::nonNull);
            this.adaptiveCrosshairUseItems = builder.comment("Items that when used, trigger the dynamic crosshair in adaptive mode. This config option supports regular expressions. Example: 'minecraft:.*sword' matches 'minecraft:wooden_sword' and 'minecraft:netherite_sword'.").translation("shouldersurfing.configuration.crosshair.adaptive_crosshair_use_items").defineList("adaptive_crosshair_use_items", ArrayList::new, Objects::nonNull);
            this.adaptiveCrosshairHoldItemProperties = builder.comment("Item properties of an item, that when held, trigger the dynamic crosshair in adaptive mode.").translation("shouldersurfing.configuration.crosshair.adaptive_crosshair_hold_item_properties").defineList("adaptive_crosshair_hold_item_properties", () -> {
                ArrayList<String> items = new ArrayList<String>();
                items.add(new ResourceLocation("charged").toString());
                return items;
            }, item -> item != null && ResourceLocation.m_135830_((String)item.toString()));
            this.adaptiveCrosshairUseItemProperties = builder.comment("Item properties of an item, that when used, trigger the dynamic crosshair in adaptive mode.").translation("shouldersurfing.configuration.crosshair.adaptive_crosshair_use_item_properties").defineList("adaptive_crosshair_use_item_properties", () -> {
                ArrayList<String> items = new ArrayList<String>();
                items.add(new ResourceLocation("pull").toString());
                items.add(new ResourceLocation("throwing").toString());
                return items;
            }, item -> item != null && ResourceLocation.m_135830_((String)item.toString()));
            builder.push("obstruction");
            this.showObstructionIndicator = builder.comment("When the crosshair type is static, shows an additional indicator on obstacles that stand between you and your target.").translation("shouldersurfing.configuration.obstruction.show_obstruction_indicator").define("show_obstruction_indicator", true);
            this.showObstructionIndicatorWhenAiming = builder.comment("Only show the obstruction indicator when using items that would trigger the adaptive crosshair.").translation("shouldersurfing.configuration.obstruction.only_when_aiming").define("only_when_aiming", true);
            this.obstructionIndicatorMinDistanceToCrosshair = builder.comment("Hide the obstruction indicator when it is too close to the main crosshair. Distance measured in scaled pixels.").translation("shouldersurfing.configuration.obstruction.min_distance_to_crosshair").defineInRange("min_distance_to_crosshair", 8, 0, Integer.MAX_VALUE);
            this.obstructionIndicatorMaxDistanceToObstruction = builder.comment("Ignore obstructions that are too far away from the player. Distance measured in blocks. Set to 0 to disable.").translation("shouldersurfing.configuration.obstruction.max_distance_to_obstruction").defineInRange("max_distance_to_obstruction", 20.0, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("visibility");
            for (Perspective entry : Perspective.values()) {
                String key = entry.toString().toLowerCase();
                ForgeConfigSpec.EnumValue crosshairVisibility = builder.comment("Crosshair visibility for " + key.replace('_', ' ') + ".").translation("shouldersurfing.configuration.crosshair.visibility." + key).defineEnum(entry.toString().toLowerCase(), (Enum)entry.getDefaultCrosshairVisibility(), (Enum[])CrosshairVisibility.values());
                this.crosshairVisibility.put(entry, (ForgeConfigSpec.ConfigValue<CrosshairVisibility>)crosshairVisibility);
            }
            builder.pop();
            builder.pop();
            builder.push("audio");
            this.centerPlayerSounds = builder.comment("Whether to center sounds made by the player.").translation("shouldersurfing.configuration.audio.center_player_sounds").define("center_player_sounds", false);
            builder.pop();
            builder.push("integrations");
            builder.push("curios");
            this.curiosAdaptiveCrosshairItems = builder.comment("Items that when equipped in a curios slot, trigger the dynamic crosshair in adaptive mode. This config option supports regular expressions. The curios slot must be specified before the expression and is separated by an '@' character. Example: 'ring@angelring:.*_ring' matches 'angelring:diamond_ring' and 'angelring:angel_ring' when equipped in the 'ring' slot.").translation("shouldersurfing.configuration.integrations.curios.adaptive_crosshair_items").defineList("adaptive_crosshair_items", ArrayList::new, ClientConfig::isValidItemWithSlot);
            this.curiosAdaptiveCrosshairItemProperties = builder.comment("Item properties of an item, that when equipped in a curios slot, trigger the dynamic crosshair in adaptive mode. Example: 'necklace@charged'").translation("shouldersurfing.configuration.integrations.curios.adaptive_crosshair_item_properties").defineList("adaptive_crosshair_item_properties", ArrayList::new, ClientConfig::isValidItemPropertyWithSlot);
            builder.pop();
            builder.push("epicfight");
            this.epicFightDecoupledCameraLockOn = builder.comment("Whether to allow target lock-on when camera is decoupled.").translation("shouldersurfing.configuration.integrations.epicfight.decoupled_camera_lock_on").define("decoupled_camera_lock_on", false);
            builder.pop();
            builder.pop();
        }

        @Override
        public double getOffsetX() {
            return (Double)this.offsetX.get();
        }

        @Override
        public double getOffsetY() {
            return (Double)this.offsetY.get();
        }

        @Override
        public double getOffsetZ() {
            return (Double)this.offsetZ.get();
        }

        @Override
        public List<Double> getOffsetXPresets() {
            return ((List)this.offsetXPresets.get()).stream().map(Double::parseDouble).toList();
        }

        @Override
        public List<Double> getOffsetYPresets() {
            return ((List)this.offsetYPresets.get()).stream().map(Double::parseDouble).toList();
        }

        @Override
        public List<Double> getOffsetZPresets() {
            return ((List)this.offsetZPresets.get()).stream().map(Double::parseDouble).toList();
        }

        @Override
        public double getMinOffsetX() {
            return (Double)this.minOffsetX.get();
        }

        @Override
        public double getMinOffsetY() {
            return (Double)this.minOffsetY.get();
        }

        @Override
        public double getMinOffsetZ() {
            return (Double)this.minOffsetZ.get();
        }

        @Override
        public double getMaxOffsetX() {
            return (Double)this.maxOffsetX.get();
        }

        @Override
        public double getMaxOffsetY() {
            return (Double)this.maxOffsetY.get();
        }

        @Override
        public double getMaxOffsetZ() {
            return (Double)this.maxOffsetZ.get();
        }

        @Override
        public boolean isUnlimitedOffsetX() {
            return (Boolean)this.unlimitedOffsetX.get();
        }

        @Override
        public boolean isUnlimitedOffsetY() {
            return (Boolean)this.unlimitedOffsetY.get();
        }

        @Override
        public boolean isUnlimitedOffsetZ() {
            return (Boolean)this.unlimitedOffsetZ.get();
        }

        @Override
        public double getPassengerOffsetXMultiplier() {
            return (Double)this.passengerOffsetXMultiplier.get();
        }

        @Override
        public double getPassengerOffsetYMultiplier() {
            return (Double)this.passengerOffsetYMultiplier.get();
        }

        @Override
        public double getPassengerOffsetZMultiplier() {
            return (Double)this.passengerOffsetZMultiplier.get();
        }

        @Override
        public double getSprintOffsetXMultiplier() {
            return (Double)this.sprintOffsetXMultiplier.get();
        }

        @Override
        public double getSprintOffsetYMultiplier() {
            return (Double)this.sprintOffsetYMultiplier.get();
        }

        @Override
        public double getSprintOffsetZMultiplier() {
            return (Double)this.sprintOffsetZMultiplier.get();
        }

        @Override
        public double getAimingOffsetXMultiplier() {
            return (Double)this.aimingOffsetXMultiplier.get();
        }

        @Override
        public double getAimingOffsetYMultiplier() {
            return (Double)this.aimingOffsetYMultiplier.get();
        }

        @Override
        public double getAimingOffsetZMultiplier() {
            return (Double)this.aimingOffsetZMultiplier.get();
        }

        @Override
        public double getFallFlyingOffsetXMultiplier() {
            return (Double)this.fallFlyingOffsetXMultiplier.get();
        }

        @Override
        public double getFallFlyingOffsetYMultiplier() {
            return (Double)this.fallFlyingOffsetYMultiplier.get();
        }

        @Override
        public double getFallFlyingOffsetZMultiplier() {
            return (Double)this.fallFlyingOffsetZMultiplier.get();
        }

        @Override
        public double getClimbingOffsetXMultiplier() {
            return (Double)this.climbingOffsetXMultiplier.get();
        }

        @Override
        public double getClimbingOffsetYMultiplier() {
            return (Double)this.climbingOffsetYMultiplier.get();
        }

        @Override
        public double getClimbingOffsetZMultiplier() {
            return (Double)this.climbingOffsetZMultiplier.get();
        }

        @Override
        public double getPassengerOffsetXModifier() {
            return (Double)this.passengerOffsetXModifier.get();
        }

        @Override
        public double getPassengerOffsetYModifier() {
            return (Double)this.passengerOffsetYModifier.get();
        }

        @Override
        public double getPassengerOffsetZModifier() {
            return (Double)this.passengerOffsetZModifier.get();
        }

        @Override
        public double getSprintOffsetXModifier() {
            return (Double)this.sprintOffsetXModifier.get();
        }

        @Override
        public double getSprintOffsetYModifier() {
            return (Double)this.sprintOffsetYModifier.get();
        }

        @Override
        public double getSprintOffsetZModifier() {
            return (Double)this.sprintOffsetZModifier.get();
        }

        @Override
        public double getAimingOffsetXModifier() {
            return (Double)this.aimingOffsetXModifier.get();
        }

        @Override
        public double getAimingOffsetYModifier() {
            return (Double)this.aimingOffsetYModifier.get();
        }

        @Override
        public double getAimingOffsetZModifier() {
            return (Double)this.aimingOffsetZModifier.get();
        }

        @Override
        public double getFallFlyingOffsetXModifier() {
            return (Double)this.fallFlyingOffsetXModifier.get();
        }

        @Override
        public double getFallFlyingOffsetYModifier() {
            return (Double)this.fallFlyingOffsetYModifier.get();
        }

        @Override
        public double getFallFlyingOffsetZModifier() {
            return (Double)this.fallFlyingOffsetZModifier.get();
        }

        @Override
        public double getClimbingOffsetXModifier() {
            return (Double)this.climbingOffsetXModifier.get();
        }

        @Override
        public double getClimbingOffsetYModifier() {
            return (Double)this.climbingOffsetYModifier.get();
        }

        @Override
        public double getClimbingOffsetZModifier() {
            return (Double)this.climbingOffsetZModifier.get();
        }

        @Override
        public CrosshairVisibility getCrosshairVisibility(Perspective perspective) {
            return (CrosshairVisibility)((Object)this.crosshairVisibility.get((Object)perspective).get());
        }

        @Override
        public boolean useCustomRaytraceDistance() {
            return (Boolean)this.useCustomRaytraceDistance.get();
        }

        @Override
        public double keepCameraOutOfHeadMultiplier() {
            return (Double)this.keepCameraOutOfHeadMultiplier.get();
        }

        @Override
        public boolean replaceDefaultPerspective() {
            return (Boolean)this.replaceDefaultPerspective.get();
        }

        @Override
        public boolean isFirstPersonEnabled() {
            return (Boolean)this.isFirstPersonEnabled.get();
        }

        @Override
        public boolean isThirdPersonFrontEnabled() {
            return (Boolean)this.isThirdPersonFrontEnabled.get();
        }

        @Override
        public boolean isThirdPersonBackEnabled() {
            return (Boolean)this.isThirdPersonBackEnabled.get();
        }

        @Override
        public Perspective getDefaultPerspective() {
            return (Perspective)((Object)this.defaultPerspective.get());
        }

        public void setDefaultPerspective(Perspective perspective) {
            Config.set(this.defaultPerspective, perspective);
        }

        @Override
        public CrosshairType getCrosshairType() {
            return (CrosshairType)((Object)this.crosshairType.get());
        }

        @Override
        public boolean doRememberLastPerspective() {
            return (Boolean)this.rememberLastPerspective.get();
        }

        @Override
        public double getCameraStepSize() {
            return (Double)this.cameraStepSize.get();
        }

        @Override
        public double getCameraTransitionSpeedMultiplier() {
            return (Double)this.cameraTransitionSpeedMultiplier.get();
        }

        @Override
        public double getCenterCameraWhenLookingDownAngle() {
            return (Double)this.centerCameraWhenLookingDownAngle.get();
        }

        @Override
        public double getHidePlayerWhenLookingUpAngle() {
            return (Double)this.hidePlayerWhenLookingUpAngle.get();
        }

        @Override
        public boolean doDynamicallyAdjustOffsets() {
            return (Boolean)this.dynamicallyAdjustOffsets.get();
        }

        @Override
        public boolean isPlayerTransparencyEnabled() {
            return CLIENT_SPEC.isLoaded() ? (Boolean)this.playerTransparency.get() : (Boolean)this.playerTransparency.getDefault();
        }

        @Override
        public boolean turnPlayerTransparentWhenAiming() {
            return (Boolean)this.turnPlayerTransparentWhenAiming.get();
        }

        @Override
        public TurningMode getTurningModeWhenUsingItem() {
            return (TurningMode)((Object)this.turningModeWhenUsingItem.get());
        }

        @Override
        public TurningMode getTurningModeWhenAttacking() {
            return (TurningMode)((Object)this.turningModeWhenAttacking.get());
        }

        @Override
        public TurningMode getTurningModeWhenInteracting() {
            return (TurningMode)((Object)this.turningModeWhenInteraction.get());
        }

        @Override
        public TurningMode getTurningModeWhenPicking() {
            return (TurningMode)((Object)this.turningModeWhenPicking.get());
        }

        @Override
        public int getTurningLockTime() {
            return (Integer)this.turningLockTime.get();
        }

        @Override
        public PickOrigin getEntityPickOrigin() {
            return (PickOrigin)((Object)this.entityPickOrigin.get());
        }

        @Override
        public PickOrigin getBlockPickOrigin() {
            return (PickOrigin)((Object)this.blockPickOrigin.get());
        }

        @Override
        public PickVector getPickVector() {
            return (PickVector)((Object)this.pickVector.get());
        }

        @Override
        public boolean isCameraDecoupled() {
            return (Boolean)this.isCameraDecoupled.get();
        }

        @Override
        public boolean doOrientCameraOnTeleport() {
            return (Boolean)this.orientCameraOnTeleport.get();
        }

        @Override
        public boolean isFovOverrideEnabled() {
            return (Boolean)this.isFovOverrideEnabled.get();
        }

        @Override
        public float getFovOverride() {
            return ((Double)this.fovOverride.get()).floatValue();
        }

        @Override
        public double getCameraDragXMultiplier() {
            return (Double)this.cameraDragXMultiplier.get();
        }

        @Override
        public double getCameraDragYMultiplier() {
            return (Double)this.cameraDragYMultiplier.get();
        }

        @Override
        public double getCameraDragZMultiplier() {
            return (Double)this.cameraDragZMultiplier.get();
        }

        @Override
        public double getCameraSwayXMaxAngle() {
            return (Double)this.cameraSwayXMaxAngle.get();
        }

        @Override
        public double getCameraSwayZMaxAngle() {
            return (Double)this.cameraSwayZMaxAngle.get();
        }

        @Override
        public double getCameraSwayXMaxVelocity() {
            return (Double)this.cameraSwayXMaxVelocity.get();
        }

        @Override
        public double getCameraSwayZMaxVelocity() {
            return (Double)this.cameraSwayZMaxVelocity.get();
        }

        @Override
        public double getCustomRaytraceDistance() {
            return (Double)this.customRaytraceDistance.get();
        }

        @Override
        public List<? extends String> getAdaptiveCrosshairHoldItems() {
            return (List)this.adaptiveCrosshairHoldItems.get();
        }

        @Override
        public List<? extends String> getAdaptiveCrosshairUseItems() {
            return (List)this.adaptiveCrosshairUseItems.get();
        }

        @Override
        public List<? extends String> getAdaptiveCrosshairHoldItemProperties() {
            return (List)this.adaptiveCrosshairHoldItemProperties.get();
        }

        @Override
        public List<? extends String> getAdaptiveCrosshairUseItemProperties() {
            return (List)this.adaptiveCrosshairUseItemProperties.get();
        }

        @Override
        public boolean getShowObstructionCrosshair() {
            return (Boolean)this.showObstructionIndicator.get();
        }

        @Override
        public boolean showObstructionIndicatorWhenAiming() {
            return (Boolean)this.showObstructionIndicatorWhenAiming.get();
        }

        @Override
        public double getObstructionIndicatorMaxDistanceToObstruction() {
            return (Double)this.obstructionIndicatorMaxDistanceToObstruction.get();
        }

        @Override
        public int getObstructionIndicatorMinDistanceToCrosshair() {
            return (Integer)this.obstructionIndicatorMinDistanceToCrosshair.get();
        }

        @Override
        public boolean doCenterPlayerSounds() {
            return (Boolean)this.centerPlayerSounds.get();
        }

        @Override
        public boolean shouldPlayerXRotFollowCamera() {
            return (Boolean)this.playerXRotFollowsCamera.get();
        }

        @Override
        public boolean shouldPlayerYRotFollowCamera() {
            return (Boolean)this.playerYRotFollowsCamera.get();
        }

        @Override
        public double getPlayerYRotFollowAngleLimit() {
            return (Double)this.playerYRotFollowAngleLimit.get();
        }

        @Override
        public List<? extends String> getCuriosAdaptiveCrosshairItems() {
            return (List)this.curiosAdaptiveCrosshairItems.get();
        }

        @Override
        public List<? extends String> getCuriosAdaptiveCrosshairItemProperties() {
            return (List)this.curiosAdaptiveCrosshairItemProperties.get();
        }

        @Override
        public boolean getEpicFightDecoupledCameraLockOn() {
            return (Boolean)this.epicFightDecoupledCameraLockOn.get();
        }

        public void adjustCameraLeft() {
            Config.set(this.offsetX, this.addStep(this.getOffsetX(), this.getMaxOffsetX(), this.isUnlimitedOffsetX()));
        }

        public void adjustCameraRight() {
            Config.set(this.offsetX, this.subStep(this.getOffsetX(), this.getMinOffsetX(), this.isUnlimitedOffsetX()));
        }

        public void adjustCameraUp() {
            Config.set(this.offsetY, this.addStep(this.getOffsetY(), this.getMaxOffsetY(), this.isUnlimitedOffsetY()));
        }

        public void adjustCameraDown() {
            Config.set(this.offsetY, this.subStep(this.getOffsetY(), this.getMinOffsetY(), this.isUnlimitedOffsetY()));
        }

        public void adjustCameraIn() {
            Config.set(this.offsetZ, this.subStep(this.getOffsetZ(), this.getMinOffsetZ(), this.isUnlimitedOffsetZ()));
        }

        public void adjustCameraOut() {
            Config.set(this.offsetZ, this.addStep(this.getOffsetZ(), this.getMaxOffsetZ(), this.isUnlimitedOffsetZ()));
        }

        public void toggleOffsetXPreset() {
            this.toggleOffsetPreset(this.offsetX, this.getOffsetXPresets());
        }

        public void toggleOffsetYPreset() {
            this.toggleOffsetPreset(this.offsetY, this.getOffsetYPresets());
        }

        public void toggleOffsetZPreset() {
            this.toggleOffsetPreset(this.offsetZ, this.getOffsetZPresets());
        }

        private void toggleOffsetPreset(ForgeConfigSpec.DoubleValue offset, List<Double> presets) {
            if (presets.isEmpty()) {
                return;
            }
            int closestIndex = 0;
            double currentOffset = (Double)offset.get();
            double distance = Math.abs(currentOffset - presets.get(0));
            for (int x = 1; x < presets.size(); ++x) {
                double preset = presets.get(x);
                double newDistance = Math.abs(currentOffset - preset);
                if (!(newDistance <= distance)) continue;
                closestIndex = x;
                distance = newDistance;
            }
            double newOffset = closestIndex == presets.size() - 1 ? presets.get(0).doubleValue() : presets.get(closestIndex + 1).doubleValue();
            Config.set(offset, newOffset);
        }

        private double addStep(double value, double max, boolean unlimited) {
            double next = value + this.getCameraStepSize();
            if (unlimited) {
                return next;
            }
            return Math.min(next, max);
        }

        private double subStep(double value, double min, boolean unlimited) {
            double next = value - this.getCameraStepSize();
            if (unlimited) {
                return next;
            }
            return Math.max(next, min);
        }

        public void swapShoulder() {
            Config.set(this.offsetX, -this.getOffsetX());
        }

        public void toggleCameraCoupling() {
            Config.set(this.isCameraDecoupled, !this.isCameraDecoupled());
        }

        private static boolean isValidDouble(Object number) {
            if (number != null) {
                try {
                    Double.parseDouble(number.toString());
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        }

        private static boolean isValidItemWithSlot(Object id) {
            if (id == null) {
                return false;
            }
            String[] split = id.toString().split("@", 2);
            if (split.length < 2) {
                return false;
            }
            return ResourceLocationAccessor.invokeIsValidNamespace(split[0]) && split[1] != null;
        }

        private static boolean isValidItemPropertyWithSlot(Object id) {
            if (id == null) {
                return false;
            }
            String[] split = id.toString().split("@", 2);
            if (split.length < 2) {
                return false;
            }
            return ResourceLocationAccessor.invokeIsValidNamespace(split[0]) && ResourceLocation.m_135820_((String)split[1]) != null;
        }
    }
}

