/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.integration;

import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import mcp.mobius.waila.api.IObjectPicker;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.plugin.core.pick.ObjectPicker;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;

public class ShoulderSurfingWthitPlugin
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.replacePicker((IObjectPicker)new ShoulderSurfingObjectPicker());
    }

    private static class ShoulderSurfingObjectPicker
    implements IObjectPicker {
        private ShoulderSurfingObjectPicker() {
        }

        public HitResult pick(Minecraft minecraft, double maxDistance, float partialTick, IPluginConfig config) {
            ShoulderSurfingImpl instance = ShoulderSurfingImpl.getInstance();
            if (instance.isShoulderSurfing() && minecraft.f_91072_ != null) {
                Camera camera = minecraft.f_91063_.m_109153_();
                PickContext pickContext = new PickContext.Builder(camera).withFluidContext(config.getBoolean(WailaConstants.CONFIG_SHOW_FLUID) ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE).build();
                com.github.exopandora.shouldersurfing.client.ObjectPicker objectPicker = instance.getObjectPicker();
                if (config.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY)) {
                    return objectPicker.pick(pickContext, maxDistance, partialTick, minecraft.f_91072_);
                }
                return objectPicker.pickBlocks(pickContext, maxDistance, partialTick);
            }
            return ObjectPicker.INSTANCE.pick(minecraft, maxDistance, partialTick, config);
        }
    }
}

