/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.mixins;

import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.github.exopandora.shouldersurfing.mixinducks.CameraDuck;
import net.minecraft.client.Camera;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class MixinCamera
implements CameraDuck {
    @Shadow
    private float xRot;
    @Shadow
    private float yRot;
    @Unique
    private float zRot;

    @Shadow
    protected abstract void move(float var1, float var2, float var3);

    @Shadow
    protected abstract void setRotation(float var1, float var2);

    @Inject(method={"setup"}, at={@At(value="HEAD")})
    private void setupRotations(CallbackInfo ci) {
        this.shouldersurfing$setZRot(0.0f);
    }

    @Inject(method={"setup"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setPosition(DDD)V", shift=At.Shift.AFTER, ordinal=0)})
    private void setupRotations(BlockGetter level, Entity cameraEntity, boolean detached, boolean isMirrored, float partialTick, CallbackInfo ci) {
        LivingEntity livingEntity;
        if (!(Perspective.SHOULDER_SURFING != Perspective.current() || cameraEntity instanceof LivingEntity && (livingEntity = (LivingEntity)cameraEntity).isSleeping())) {
            ShoulderSurfingCamera camera = ShoulderSurfingImpl.getInstance().getCamera();
            Vec2f rotations = camera.calcRotations(cameraEntity, partialTick);
            this.setRotation(rotations.y(), rotations.x());
        }
    }

    @Redirect(method={"setup"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;move(FFF)V", ordinal=0))
    private void setupPosition(Camera cameraIn, float x, float y, float z, BlockGetter level, Entity cameraEntity, boolean detached, boolean isMirrored, float partialTick) {
        LivingEntity livingEntity;
        if (!(Perspective.SHOULDER_SURFING != Perspective.current() || cameraEntity instanceof LivingEntity && (livingEntity = (LivingEntity)cameraEntity).isSleeping())) {
            ShoulderSurfingCamera camera = ShoulderSurfingImpl.getInstance().getCamera();
            Vec3 cameraOffset = camera.calcOffset(cameraIn, level, partialTick, cameraEntity);
            this.move((float)(-cameraOffset.z()), (float)cameraOffset.y(), (float)(-cameraOffset.x()));
            Vec2f sway = camera.calcSway(camera, cameraEntity, partialTick);
            this.zRot = sway.y();
            this.setRotation(this.yRot, this.xRot + sway.x());
        } else {
            this.move(x, y, z);
        }
    }

    @Override
    public float shouldersurfing$getZRot() {
        return this.zRot;
    }

    @Override
    public void shouldersurfing$setZRot(float zRot) {
        this.zRot = zRot;
    }
}

