/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.plugin.callbacks;

import com.github.exopandora.shouldersurfing.api.callback.IAdaptiveItemCallback;
import com.github.exopandora.shouldersurfing.config.Config;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AdaptiveItemCallback
implements IAdaptiveItemCallback {
    @Override
    public boolean isHoldingAdaptiveItem(Minecraft minecraft, LivingEntity entity) {
        ItemStack[] handItems;
        List<? extends String> adaptiveCrosshairUseItemAnimations;
        List<? extends String> useItemComponents;
        List<? extends String> useItems;
        ItemStack useStack = entity.getUseItem();
        if (AdaptiveItemCallback.isAdaptiveItemStack(useStack, useItems = Config.CLIENT.getAdaptiveCrosshairUseItems(), useItemComponents = Config.CLIENT.getAdaptiveCrosshairUseItemComponents(), adaptiveCrosshairUseItemAnimations = Config.CLIENT.getAdaptiveCrosshairUseItemAnimations())) {
            return true;
        }
        List<? extends String> holdItems = Config.CLIENT.getAdaptiveCrosshairHoldItems();
        List<? extends String> holdItemComponents = Config.CLIENT.getAdaptiveCrosshairHoldItemComponents();
        List<? extends String> holdItemAnimations = Config.CLIENT.getAdaptiveCrosshairHoldItemAnimations();
        for (ItemStack handStack : handItems = new ItemStack[]{entity.getMainHandItem(), entity.getOffhandItem()}) {
            if (!AdaptiveItemCallback.isAdaptiveItemStack(handStack, holdItems, holdItemComponents, holdItemAnimations)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdaptiveItemStack(ItemStack stack, List<? extends String> expressions, List<? extends String> componentIds, List<? extends String> itemAnimations) {
        String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        if (expressions.stream().map(AdaptiveItemCallback::expressionToMatchPredicate).anyMatch(pattern -> pattern.test(itemId))) {
            return true;
        }
        if (!stack.getComponentsPatch().isEmpty()) {
            DataComponentPatch patch = stack.getComponentsPatch();
            for (String string : componentIds) {
                Optional component;
                Optional type = BuiltInRegistries.DATA_COMPONENT_TYPE.getOptional(ResourceLocation.tryParse((String)string));
                if (type.isEmpty() || (component = patch.get((DataComponentType)type.get())) == null || !component.isPresent()) continue;
                return true;
            }
        }
        String useAnimation = stack.getUseAnimation().getSerializedName();
        for (String string : itemAnimations) {
            if (!string.equals(useAnimation)) continue;
            return true;
        }
        return false;
    }

    private static Predicate<String> expressionToMatchPredicate(String expression) {
        try {
            return Pattern.compile(expression).asMatchPredicate();
        }
        catch (Exception e) {
            return expression::equals;
        }
    }
}

