/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.api.model;

import com.github.exopandora.shouldersurfing.api.client.IClientConfig;
import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.model.CrosshairVisibility;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;

public enum Perspective {
    FIRST_PERSON(CameraType.FIRST_PERSON, CrosshairVisibility.ALWAYS),
    THIRD_PERSON_BACK(CameraType.THIRD_PERSON_BACK, CrosshairVisibility.NEVER),
    THIRD_PERSON_FRONT(CameraType.THIRD_PERSON_FRONT, CrosshairVisibility.NEVER),
    SHOULDER_SURFING(CameraType.THIRD_PERSON_BACK, CrosshairVisibility.ALWAYS);

    private final CameraType cameraType;
    private final CrosshairVisibility defaultCrosshairVisibility;

    private Perspective(CameraType cameraType, CrosshairVisibility defaultCrosshairVisibility) {
        this.cameraType = cameraType;
        this.defaultCrosshairVisibility = defaultCrosshairVisibility;
    }

    public CameraType getCameraType() {
        return this.cameraType;
    }

    public CrosshairVisibility getDefaultCrosshairVisibility() {
        return this.defaultCrosshairVisibility;
    }

    public Perspective next(IClientConfig config) {
        Perspective next;
        if (config.replaceDefaultPerspective()) {
            next = switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> SHOULDER_SURFING;
                case 2 -> FIRST_PERSON;
                case 3 -> THIRD_PERSON_FRONT;
            };
        } else {
            next = Perspective.values()[(this.ordinal() + 1) % Perspective.values().length];
        }
        switch (next.ordinal()) {
            case 0: {
                if (!config.isFirstPersonEnabled()) break;
                return FIRST_PERSON;
            }
            case 1: {
                if (!config.isThirdPersonBackEnabled()) break;
                return THIRD_PERSON_BACK;
            }
            case 2: {
                if (!config.isThirdPersonFrontEnabled()) break;
                return THIRD_PERSON_FRONT;
            }
            case 3: {
                return SHOULDER_SURFING;
            }
        }
        return next.next(config);
    }

    public boolean isEnabled(IClientConfig config) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> config.isFirstPersonEnabled();
            case 1 -> {
                if (config.isThirdPersonBackEnabled() && !config.replaceDefaultPerspective()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> config.isThirdPersonFrontEnabled();
            case 3 -> true;
        };
    }

    public static Perspective of(CameraType cameraType, boolean shoulderSurfing) {
        return switch (cameraType) {
            default -> throw new MatchException(null, null);
            case CameraType.FIRST_PERSON -> FIRST_PERSON;
            case CameraType.THIRD_PERSON_BACK -> {
                if (shoulderSurfing) {
                    yield SHOULDER_SURFING;
                }
                yield THIRD_PERSON_BACK;
            }
            case CameraType.THIRD_PERSON_FRONT -> THIRD_PERSON_FRONT;
        };
    }

    public static Perspective current() {
        return Perspective.of(Minecraft.getInstance().options.getCameraType(), ShoulderSurfing.getInstance().isShoulderSurfing());
    }
}

