/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.plugin.callbacks;

import com.github.exopandora.shouldersurfing.api.callback.IAdaptiveItemCallback;
import com.github.exopandora.shouldersurfing.config.Config;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AdaptiveItemCallback
implements IAdaptiveItemCallback {
    @Override
    public boolean isHoldingAdaptiveItem(Minecraft minecraft, LivingEntity entity) {
        ItemStack[] handItems;
        List<? extends String> useItemProperties;
        List<? extends String> useItems;
        ItemStack useStack = entity.getUseItem();
        if (AdaptiveItemCallback.isAdaptiveItemStack(useStack, useItems = Config.CLIENT.getAdaptiveCrosshairUseItems(), useItemProperties = Config.CLIENT.getAdaptiveCrosshairUseItemProperties())) {
            return true;
        }
        List<? extends String> holdItems = Config.CLIENT.getAdaptiveCrosshairHoldItems();
        List<? extends String> holdItemProperties = Config.CLIENT.getAdaptiveCrosshairHoldItemProperties();
        for (ItemStack handStack : handItems = new ItemStack[]{entity.getMainHandItem(), entity.getOffhandItem()}) {
            if (!AdaptiveItemCallback.isAdaptiveItemStack(handStack, holdItems, holdItemProperties)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdaptiveItemStack(ItemStack stack, List<? extends String> expressions, List<? extends String> itemProperties) {
        String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        if (expressions.stream().map(AdaptiveItemCallback::expressionToMatchPredicate).anyMatch(pattern -> pattern.test(itemId))) {
            return true;
        }
        for (String string : itemProperties) {
            if (ItemProperties.getProperty((ItemStack)stack, (ResourceLocation)ResourceLocation.parse((String)string)) == null) continue;
            return true;
        }
        return false;
    }

    private static Predicate<String> expressionToMatchPredicate(String expression) {
        try {
            return Pattern.compile(expression).asMatchPredicate();
        }
        catch (Exception e) {
            return expression::equals;
        }
    }
}

