/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.callback.ICameraEntityTransparencyCallback;
import com.github.exopandora.shouldersurfing.api.client.ICameraEntityRenderer;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3532;
import net.minecraft.class_9848;

public class CameraEntityRenderer
implements ICameraEntityRenderer {
    private final ShoulderSurfingImpl instance;
    private float cameraEntityAlpha = 1.0f;
    private boolean isRenderingCameraEntity;
    private class_10017 cameraEntityRenderState;

    public CameraEntityRenderer(ShoulderSurfingImpl instance) {
        this.instance = instance;
    }

    public boolean preRenderCameraEntity(class_1297 entity, float partialTick) {
        if (this.shouldSkipCameraEntityRendering(entity)) {
            return true;
        }
        this.cameraEntityAlpha = 1.0f;
        if (this.instance.isShoulderSurfing() && Config.CLIENT.isPlayerTransparencyEnabled()) {
            for (ICameraEntityTransparencyCallback callback : ShoulderSurfingRegistrar.getInstance().getCameraEntityTransparencyCallbacks()) {
                this.cameraEntityAlpha = Math.min(class_3532.method_15363((float)callback.getCameraEntityAlpha(this.instance, entity, partialTick), (float)0.0f, (float)1.0f), this.cameraEntityAlpha);
            }
        }
        this.isRenderingCameraEntity = true;
        return false;
    }

    public void postRenderCameraEntity(class_1297 entity, float partialTick) {
        this.isRenderingCameraEntity = false;
    }

    private boolean shouldSkipCameraEntityRendering(class_1297 cameraEntity) {
        class_1657 player;
        ShoulderSurfingCamera camera = this.instance.getCamera();
        return this.instance.isShoulderSurfing() && !cameraEntity.method_7325() && (camera.getCameraDistance() < (double)cameraEntity.method_17681() * Config.CLIENT.keepCameraOutOfHeadMultiplier() || (double)camera.getXRot() < Config.CLIENT.getHidePlayerWhenLookingUpAngle() - 90.0 || cameraEntity instanceof class_1657 && (player = (class_1657)cameraEntity).method_31550());
    }

    public int applyCameraEntityAlphaContextAware(int color) {
        return this.isRenderingCameraEntity ? this.applyCameraEntityAlpha(color) : color;
    }

    public int applyCameraEntityAlpha(int color) {
        int alpha;
        int cameraEntityAlpha = this.getCameraEntityAlphaAsInt();
        if (cameraEntityAlpha < (alpha = class_9848.method_61320((int)color))) {
            return class_9848.method_61335((int)color) + (cameraEntityAlpha << 24);
        }
        return color;
    }

    public class_10017 getCameraEntityRenderState() {
        return this.cameraEntityRenderState;
    }

    public void setCameraEntityRenderState(class_10017 cameraEntityRenderState) {
        this.cameraEntityRenderState = cameraEntityRenderState;
    }

    @Override
    public boolean isRenderingCameraEntity() {
        return this.isRenderingCameraEntity;
    }

    @Override
    public float getCameraEntityAlpha() {
        return this.cameraEntityAlpha;
    }

    @Override
    public int getCameraEntityAlphaAsInt() {
        return class_9848.method_61326((float)this.cameraEntityAlpha);
    }
}

