/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.plugin.callbacks;

import com.github.exopandora.shouldersurfing.api.callback.IAdaptiveItemCallback;
import com.github.exopandora.shouldersurfing.config.Config;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AdaptiveItemCallback
implements IAdaptiveItemCallback {
    @Override
    public boolean isHoldingAdaptiveItem(Minecraft minecraft, LivingEntity entity) {
        ItemStack[] handItems;
        List<? extends String> useItemProperties;
        List<? extends String> useItems;
        Item useItem = entity.m_21211_().m_41720_();
        if (AdaptiveItemCallback.isAdaptiveItemStack(useItem, useItems = Config.CLIENT.getAdaptiveCrosshairUseItems(), useItemProperties = Config.CLIENT.getAdaptiveCrosshairUseItemProperties())) {
            return true;
        }
        List<? extends String> holdItems = Config.CLIENT.getAdaptiveCrosshairHoldItems();
        List<? extends String> holdItemProperties = Config.CLIENT.getAdaptiveCrosshairHoldItemProperties();
        for (ItemStack handStack : handItems = new ItemStack[]{entity.m_21205_(), entity.m_21206_()}) {
            if (!AdaptiveItemCallback.isAdaptiveItemStack(handStack.m_41720_(), holdItems, holdItemProperties)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdaptiveItemStack(Item item, List<? extends String> expressions, List<? extends String> itemProperties) {
        String itemId = Registry.f_122827_.m_7981_((Object)item).toString();
        if (expressions.stream().map(AdaptiveItemCallback::expressionToMatchPredicate).anyMatch(pattern -> pattern.test(itemId))) {
            return true;
        }
        for (String string : itemProperties) {
            if (ItemProperties.m_117829_((Item)item, (ResourceLocation)new ResourceLocation(string)) == null) continue;
            return true;
        }
        return false;
    }

    private static Predicate<String> expressionToMatchPredicate(String expression) {
        try {
            return Pattern.compile(expression).asMatchPredicate();
        }
        catch (Exception e) {
            return expression::equals;
        }
    }
}

