/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.api.model;

import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public enum PickVector {
    PLAYER((camera, entity, partialTick) -> PickVector.entityViewVector(entity, partialTick)),
    CAMERA((camera, entity, partialTick) -> new Vec3(camera.m_90596_()));

    private final IPickVectorFunction pickVectorFunction;

    private PickVector(IPickVectorFunction pickVectorFunction) {
        this.pickVectorFunction = pickVectorFunction;
    }

    public Vec3 calc(Camera camera, Entity entity, float partialTick) {
        return this.pickVectorFunction.apply(camera, entity, partialTick);
    }

    @NotNull
    private static Vec3 entityViewVector(Entity entity, float partialTick) {
        float xRot = partialTick == 1.0f ? entity.m_146909_() : Mth.m_14189_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_());
        float yRot = partialTick == 1.0f ? entity.m_146908_() : Mth.m_14189_((float)partialTick, (float)entity.f_19859_, (float)entity.m_146908_());
        float xRotDeg = xRot * ((float)Math.PI / 180);
        float yRotDegNegated = -yRot * ((float)Math.PI / 180);
        float a = Mth.m_14089_((float)yRotDegNegated);
        float b = Mth.m_14031_((float)yRotDegNegated);
        float c = Mth.m_14089_((float)xRotDeg);
        float d = Mth.m_14031_((float)xRotDeg);
        return new Vec3((double)(b * c), (double)(-d), (double)(a * c));
    }

    private static interface IPickVectorFunction {
        public Vec3 apply(Camera var1, Entity var2, float var3);
    }
}

