/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.neoforge.compat;

import com.github.exopandora.shouldersurfing.compat.Mods;
import com.github.exopandora.shouldersurfing.compat.ShoulderSurfingCompatMixinPlugin;
import com.github.exopandora.shouldersurfing.neoforge.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ShoulderSurfingCompatMixinPluginNeoForge
extends ShoulderSurfingCompatMixinPlugin {
    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        ShoulderSurfingCompatMixinPluginNeoForge.addCobblemonMixins(mixins);
        ShoulderSurfingCompatMixinPluginNeoForge.addCommonCompatMixins(mixins);
        ShoulderSurfingCompatMixinPluginNeoForge.addCreateModMixins(mixins);
        ShoulderSurfingCompatMixinPluginNeoForge.addShaderMixins(mixins);
        return mixins.isEmpty() ? null : mixins;
    }

    private static void addShaderMixins(List<String> mixins) {
        ArtifactVersion version = ShoulderSurfingCompatMixinPluginNeoForge.highestShaderVersion();
        if (version != null) {
            if (Platform.parseVersionRangeSilent("[1.7.0-snapshot,)").containsVersion(version)) {
                mixins.add("iris.MixinSheets_1_7_0");
            } else if (Platform.parseVersionRangeSilent("[1.6.15,1.7.0)").containsVersion(version)) {
                mixins.add("iris.MixinSheets_1_6_15");
            }
        }
    }

    private static void addCreateModMixins(List<String> mixins) {
        String createModVersion = Mods.CREATE.getModVersion();
        if (createModVersion != null) {
            DefaultArtifactVersion version = new DefaultArtifactVersion(createModVersion);
            if (Platform.parseVersionRangeSilent("[6.0.0,)").containsVersion((ArtifactVersion)version)) {
                mixins.add("create.MixinContraptionHandlerClient_6_0_0");
            } else if (Platform.parseVersionRangeSilent("(,6.0.0)").containsVersion((ArtifactVersion)version)) {
                mixins.add("create.MixinContraptionHandlerClient_0_5_0");
            }
        }
    }

    private static void addCobblemonMixins(List<String> mixins) {
        String cobblemonVersion = Mods.COBBLEMON.getModVersion();
        if (cobblemonVersion != null) {
            DefaultArtifactVersion version = new DefaultArtifactVersion(cobblemonVersion);
            if (Platform.parseVersionRangeSilent("[1.7.0,)").containsVersion((ArtifactVersion)version)) {
                mixins.add("cobblemon.MixinLocalPlayer");
                mixins.add("cobblemon.MixinPlayerExtensionsKt_1_7");
            } else if (Platform.parseVersionRangeSilent("(,1.7.0)").containsVersion((ArtifactVersion)version)) {
                mixins.add("cobblemon.MixinPlayerExtensionsKt_1_6");
            }
            mixins.add("cobblemon.MixinPokemonRenderer");
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Nullable
    private static ArtifactVersion highestShaderVersion() {
        ArrayList<String> shaderVersions = new ArrayList<String>();
        shaderVersions.add(Mods.OCULUS.getModVersion());
        shaderVersions.add(Mods.IRIS.getModVersion());
        shaderVersions.removeIf(Objects::isNull);
        return switch (shaderVersions.size()) {
            case 0 -> null;
            case 1 -> new DefaultArtifactVersion((String)shaderVersions.getFirst());
            default -> shaderVersions.stream().map(DefaultArtifactVersion::new).sorted().findFirst().orElse(null);
        };
    }
}

