/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.client.ICrosshairRenderer;
import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.github.exopandora.shouldersurfing.mixins.GuiAccessor;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1041;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class CrosshairRenderer
implements ICrosshairRenderer {
    private static final class_2960 OBSTRUCTION_INDICATOR_SPRITE = new class_2960("shouldersurfing", "textures/gui/sprites/hud/obstruction_indicator.png");
    private static final class_2960 OBSTRUCTED_CROSSHAIR_SPRITE = new class_2960("shouldersurfing", "textures/gui/sprites/hud/obstructed_crosshair.png");
    private static final class_2960 OBSTRUCTED_CROSSHAIR_CROSS_SPRITE = new class_2960("shouldersurfing", "textures/gui/sprites/hud/obstructed_crosshair_cross.png");
    private final ShoulderSurfingImpl instance;
    private Vec2f crosshairOffset;

    public CrosshairRenderer(ShoulderSurfingImpl instance) {
        this.instance = instance;
        this.init();
    }

    private void init() {
        this.crosshairOffset = null;
    }

    public void preRenderCrosshair(class_4587 poseStack) {
        boolean isDynamic = this.isCrosshairDynamic(class_310.method_1551().method_1560());
        if (isDynamic || this.doRenderObstructionCrosshair()) {
            this.setupPoseStack(poseStack);
        }
    }

    public void postRenderCrosshair(class_4587 poseStack) {
        boolean doRenderObstructionCrosshair = this.doRenderObstructionCrosshair();
        boolean isDynamic = this.isCrosshairDynamic(class_310.method_1551().method_1560());
        if (isDynamic || doRenderObstructionCrosshair) {
            this.resetPoseStack(poseStack);
        }
        if (doRenderObstructionCrosshair) {
            this.renderObstructionCrosshair(poseStack);
        } else if (this.doRenderObstructionIndicator()) {
            this.setupPoseStack(poseStack);
            this.renderObstructionIndicator(poseStack);
            this.resetPoseStack(poseStack);
        }
    }

    private void setupPoseStack(class_4587 poseStack) {
        if (this.crosshairOffset != null) {
            poseStack.method_22903();
            poseStack.method_23760().method_23761().method_22671(new class_1160(this.crosshairOffset.x(), -this.crosshairOffset.y(), 0.0f));
        }
    }

    private void resetPoseStack(class_4587 poseStack) {
        if (this.crosshairOffset != null) {
            poseStack.method_22909();
        }
    }

    @Override
    public boolean doRenderCrosshair() {
        return Config.CLIENT.getCrosshairVisibility(Perspective.current()).doRender(class_310.method_1551().field_1765, this.instance.isAiming()) && (this.crosshairOffset != null || !this.isCrosshairDynamic(class_310.method_1551().method_1560()));
    }

    @Override
    public boolean doRenderObstructionCrosshair() {
        return this.doRenderObstructionIndicator() && this.instance.isAiming();
    }

    @Override
    public boolean doRenderObstructionIndicator() {
        int minDistanceToCrosshair = Config.CLIENT.getObstructionIndicatorMinDistanceToCrosshair();
        return this.crosshairOffset != null && this.instance.isShoulderSurfing() && Config.CLIENT.getShowObstructionCrosshair() && (this.instance.isAiming() || !Config.CLIENT.showObstructionIndicatorWhenAiming()) && !this.isCrosshairDynamic(class_310.method_1551().method_1560()) && this.crosshairOffset.lengthSquared() >= (double)(minDistanceToCrosshair * minDistanceToCrosshair);
    }

    public void updateDynamicRaytrace(class_4184 camera, class_1159 modelViewMatrix, class_1159 projectionMatrix, float partialTick) {
        if (this.instance.isShoulderSurfing() && class_310.method_1551().field_1724 != null) {
            boolean isDynamic = this.isCrosshairDynamic(class_310.method_1551().method_1560());
            double interactionRangeOverride = Config.CLIENT.useCustomRaytraceDistance() ? Config.CLIENT.getCustomRaytraceDistance() : 0.0;
            class_636 gameMode = class_310.method_1551().field_1761;
            class_746 player = class_310.method_1551().field_1724;
            PickContext.Builder pickContextBuilder = new PickContext.Builder(camera);
            if (isDynamic) {
                pickContextBuilder.dynamicTrace();
            }
            PickContext pickContext = pickContextBuilder.build();
            class_239 hitResult = this.instance.getObjectPicker().pick(pickContext, interactionRangeOverride, partialTick, gameMode);
            class_243 position = hitResult.method_17784();
            if (!isDynamic) {
                pickContext = pickContextBuilder.obstructionTrace(position).build();
                hitResult = this.instance.getObjectPicker().pick(pickContext, interactionRangeOverride, partialTick, gameMode);
                position = hitResult.method_17784();
            }
            Vec2f projected = CrosshairRenderer.project2D(position.method_1020(camera.method_19326()), modelViewMatrix, projectionMatrix);
            Vec2f crosshairOffset = null;
            if (projected != null) {
                class_1041 window = class_310.method_1551().method_22683();
                Vec2f screenSize = new Vec2f(window.method_4480(), window.method_4507());
                Vec2f center = screenSize.divide(2.0f);
                double maxDistanceToObstruction = Config.CLIENT.getObstructionIndicatorMaxDistanceToObstruction();
                if (isDynamic || !Config.CLIENT.getShowObstructionCrosshair() || maxDistanceToObstruction <= 0.0 || position.method_1025(player.method_33571()) <= maxDistanceToObstruction * maxDistanceToObstruction) {
                    crosshairOffset = projected.subtract(center).divide((float)window.method_4495());
                }
            }
            this.crosshairOffset = crosshairOffset;
        }
    }

    @Override
    public boolean isCrosshairDynamic(class_1297 entity) {
        return this.instance.isShoulderSurfing() && Config.CLIENT.getCrosshairType().isDynamic(entity, this.instance.isAiming());
    }

    private void renderObstructionCrosshair(class_4587 poseStack) {
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        this.renderCustomCrosshair(poseStack, OBSTRUCTED_CROSSHAIR_SPRITE);
        RenderSystem.defaultBlendFunc();
        this.renderCustomCrosshair(poseStack, OBSTRUCTED_CROSSHAIR_CROSS_SPRITE);
    }

    private void renderObstructionIndicator(class_4587 poseStack) {
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        this.renderCustomCrosshair(poseStack, OBSTRUCTION_INDICATOR_SPRITE);
        RenderSystem.defaultBlendFunc();
    }

    private void renderCustomCrosshair(class_4587 poseStack, class_2960 sprite) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1761.method_2920() != class_1934.field_9219 || ((GuiAccessor)minecraft.field_1705).invokeCanRenderCrosshairForSpectator(minecraft.field_1765)) {
            RenderSystem.setShaderTexture((int)0, (class_2960)sprite);
            class_332.method_25290((class_4587)poseStack, (int)((minecraft.method_22683().method_4486() - 15) / 2), (int)((minecraft.method_22683().method_4502() - 15) / 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (int)15, (int)15);
        }
    }

    public void resetState() {
        this.init();
    }

    @Nullable
    private static Vec2f project2D(class_243 position, class_1159 modelView, class_1159 projection) {
        class_1041 window = class_310.method_1551().method_22683();
        int screenWidth = window.method_4480();
        int screenHeight = window.method_4507();
        if (screenWidth == 0 || screenHeight == 0) {
            return null;
        }
        class_1162 vec = new class_1162((float)position.method_10216(), (float)position.method_10214(), (float)position.method_10215(), 1.0f);
        vec.method_22674(modelView);
        vec.method_22674(projection);
        if (vec.method_23853() == 0.0f) {
            return null;
        }
        float w = 1.0f / vec.method_23853() * 0.5f;
        float x = (vec.method_4953() * w + 0.5f) * (float)screenWidth;
        float y = (vec.method_4956() * w + 0.5f) * (float)screenHeight;
        float z = vec.method_4957() * w + 0.5f;
        vec.method_23851(x, y, z, w);
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isNaN(x) || Float.isNaN(y) || w < 0.0f) {
            return null;
        }
        return new Vec2f(x, y);
    }
}

