/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.callback.ICameraEntityTransparencyCallback;
import com.github.exopandora.shouldersurfing.api.client.ICameraEntityRenderer;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CameraEntityRenderer
implements ICameraEntityRenderer {
    private final ShoulderSurfingImpl instance;
    private float cameraEntityAlpha = 1.0f;
    private boolean isRenderingCameraEntity;
    private EntityRenderState cameraEntityRenderState;

    public CameraEntityRenderer(ShoulderSurfingImpl instance) {
        this.instance = instance;
    }

    public boolean preRenderCameraEntity(Entity entity, float partialTick) {
        if (this.shouldSkipCameraEntityRendering(entity)) {
            return true;
        }
        this.cameraEntityAlpha = 1.0f;
        if (this.instance.isShoulderSurfing() && Config.CLIENT.isPlayerTransparencyEnabled()) {
            for (ICameraEntityTransparencyCallback callback : ShoulderSurfingRegistrar.getInstance().getCameraEntityTransparencyCallbacks()) {
                this.cameraEntityAlpha = Math.min(Mth.clamp((float)callback.getCameraEntityAlpha(this.instance, entity, partialTick), (float)0.0f, (float)1.0f), this.cameraEntityAlpha);
            }
        }
        this.isRenderingCameraEntity = true;
        return false;
    }

    public void postRenderCameraEntity(Entity entity, float partialTick) {
        this.isRenderingCameraEntity = false;
    }

    private boolean shouldSkipCameraEntityRendering(Entity cameraEntity) {
        Player player;
        ShoulderSurfingCamera camera = this.instance.getCamera();
        return this.instance.isShoulderSurfing() && !cameraEntity.isSpectator() && (camera.getCameraDistance() < (double)cameraEntity.getBbWidth() * Config.CLIENT.keepCameraOutOfHeadMultiplier() || (double)camera.getXRot() < Config.CLIENT.getHidePlayerWhenLookingUpAngle() - 90.0 || cameraEntity instanceof Player && (player = (Player)cameraEntity).isScoping());
    }

    public int applyCameraEntityAlphaContextAware(int color) {
        return this.isRenderingCameraEntity ? this.applyCameraEntityAlpha(color) : color;
    }

    public int applyCameraEntityAlpha(int color) {
        int alpha;
        int cameraEntityAlpha = this.getCameraEntityAlphaAsInt();
        if (cameraEntityAlpha < (alpha = ARGB.alpha((int)color))) {
            return ARGB.transparent((int)color) + (cameraEntityAlpha << 24);
        }
        return color;
    }

    public EntityRenderState getCameraEntityRenderState() {
        return this.cameraEntityRenderState;
    }

    public void setCameraEntityRenderState(EntityRenderState cameraEntityRenderState) {
        this.cameraEntityRenderState = cameraEntityRenderState;
    }

    @Override
    public boolean isRenderingCameraEntity() {
        return this.isRenderingCameraEntity;
    }

    @Override
    public float getCameraEntityAlpha() {
        return this.cameraEntityAlpha;
    }

    @Override
    public int getCameraEntityAlphaAsInt() {
        return ARGB.as8BitChannel((float)this.cameraEntityAlpha);
    }
}

