/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.fabric.compat;

import com.github.exopandora.shouldersurfing.compat.Mods;
import com.github.exopandora.shouldersurfing.compat.ShoulderSurfingCompatMixinPlugin;
import com.github.exopandora.shouldersurfing.fabric.Platform;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.Version;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ShoulderSurfingCompatMixinPluginFabric
extends ShoulderSurfingCompatMixinPlugin {
    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        ShoulderSurfingCompatMixinPluginFabric.addCobblemonMixins(mixins);
        ShoulderSurfingCompatMixinPluginFabric.addCommonCompatMixins(mixins);
        ShoulderSurfingCompatMixinPluginFabric.addCreateModMixins(mixins);
        ShoulderSurfingCompatMixinPluginFabric.addCreateFlyMixins(mixins);
        return mixins.isEmpty() ? null : mixins;
    }

    private static void addCreateModMixins(List<String> mixins) {
        if (Mods.CREATE.isLoaded()) {
            Version version = Platform.parseVersionSilent(Mods.CREATE.getModVersion());
            if (Platform.parseVersionPredicateSilent(">=6.0.0").test((Object)version)) {
                mixins.add("create.MixinContraptionHandlerClient_6_0_0");
            } else if (Platform.parseVersionPredicateSilent("<6.0.0").test((Object)version)) {
                mixins.add("create.MixinContraptionHandlerClient_0_5_0");
            }
        }
    }

    private static void addCreateFlyMixins(List<String> mixins) {
        if (Mods.CREATE_FLY.isLoaded()) {
            mixins.add("createfly.MixinContraptionHandlerClient");
        }
    }

    private static void addCobblemonMixins(List<String> mixins) {
        String cobblemonVersion = Mods.COBBLEMON.getModVersion();
        if (cobblemonVersion != null) {
            Version version = Platform.parseVersionSilent(cobblemonVersion);
            if (Platform.parseVersionPredicateSilent(">=1.7.0").test((Object)version)) {
                mixins.add("cobblemon.MixinPlayerExtensionsKt_1_7");
            } else if (Platform.parseVersionPredicateSilent("<1.7.0").test((Object)version)) {
                mixins.add("cobblemon.MixinPlayerExtensionsKt_1_6");
            }
            mixins.add("cobblemon.MixinPokemonRenderer");
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

