package com.github.exopandora.shouldersurfing.fabric.mixins;

import com.github.exopandora.shouldersurfing.mixinducks.CameraDuck;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(GameRenderer.class)
public class MixinGameRenderer
{
	@Shadow
	private @Final Camera mainCamera;
	
	@Inject
	(
		method = "renderLevel",
		at = @At
		(
			value = "INVOKE",
			target = "Lnet/minecraft/client/Camera;setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V",
			shift = Shift.AFTER
		)
	)
	private void renderLevel(float partialTick, long nanos, PoseStack poseStack, CallbackInfo ci)
	{
		poseStack.mulPose(Vector3f.ZP.rotationDegrees(((CameraDuck) this.mainCamera).shouldersurfing$getZRot()));
	}
}
