/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.plugin.callbacks;

import com.github.exopandora.shouldersurfing.api.callback.ICameraEntityTransparencyCallback;
import com.github.exopandora.shouldersurfing.api.client.IShoulderSurfing;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class CameraEntityTransparencyCallback
implements ICameraEntityTransparencyCallback {
    protected static final float MIN_CAMERA_ENTITY_ALPHA = 0.15f;

    @Override
    public float getCameraEntityAlpha(IShoulderSurfing instance, Entity entity, float partialTick) {
        if (CameraEntityTransparencyCallback.shouldRenderCameraEntityTransparent(instance, entity)) {
            Vec3 renderOffset = instance.getCamera().getRenderOffset();
            float xAlpha = (float)Mth.clamp((double)(Math.abs(renderOffset.x()) / ((double)entity.getBbWidth() / 2.0)), (double)0.0, (double)1.0);
            float yAlpha = 0.0f;
            if (renderOffset.y() > 0.0) {
                yAlpha = (float)Mth.clamp((double)(renderOffset.y() / (double)(entity.getBbHeight() - entity.getEyeHeight())), (double)0.0, (double)1.0);
            } else if (renderOffset.y() < 0.0) {
                yAlpha = (float)Mth.clamp((double)(-renderOffset.y() / (double)(-entity.getEyeHeight())), (double)0.0, (double)1.0);
            }
            return Mth.clamp((float)((float)Math.sqrt(xAlpha * xAlpha + yAlpha * yAlpha)), (float)0.15f, (float)1.0f);
        }
        return 1.0f;
    }

    private static boolean shouldRenderCameraEntityTransparent(IShoulderSurfing instance, Entity entity) {
        Vec3 renderOffset = instance.getCamera().getRenderOffset();
        return !entity.isSpectator() && Math.abs(renderOffset.x()) < (double)entity.getBbWidth() / 2.0 && (renderOffset.y() >= 0.0 && renderOffset.y() < (double)(entity.getBbHeight() - entity.getEyeHeight()) || renderOffset.y() <= 0.0 && -renderOffset.y() < (double)entity.getEyeHeight());
    }
}

