/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.fabric.compat;

import com.github.exopandora.shouldersurfing.compat.Mods;
import com.github.exopandora.shouldersurfing.compat.ShoulderSurfingCompatMixinPlugin;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ShoulderSurfingCompatMixinPluginFabric
extends ShoulderSurfingCompatMixinPlugin {
    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        ShoulderSurfingCompatMixinPluginFabric.addCommonCompatMixins(mixins);
        ShoulderSurfingCompatMixinPluginFabric.addCreateModMixins(mixins);
        ShoulderSurfingCompatMixinPluginFabric.addCreateFlyMixins(mixins);
        return mixins.isEmpty() ? null : mixins;
    }

    private static void addCreateModMixins(List<String> mixins) {
        if (Mods.CREATE.isLoaded()) {
            Version version = ShoulderSurfingCompatMixinPluginFabric.parseVersionSilent(Mods.CREATE.getModVersion());
            if (ShoulderSurfingCompatMixinPluginFabric.parseVersionPredicateSilent(">=6.0.0").test((Object)version)) {
                mixins.add("create.MixinContraptionHandlerClient_6_0_0");
            } else if (ShoulderSurfingCompatMixinPluginFabric.parseVersionPredicateSilent("<6.0.0").test((Object)version)) {
                mixins.add("create.MixinContraptionHandlerClient_0_5_0");
            }
        }
    }

    private static void addCreateFlyMixins(List<String> mixins) {
        if (Mods.CREATE_FLY.isLoaded()) {
            mixins.add("createfly.MixinContraptionHandlerClient");
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static Version parseVersionSilent(String version) {
        try {
            return Version.parse((String)version);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static VersionPredicate parseVersionPredicateSilent(String predicate) {
        try {
            return VersionPredicate.parse((String)predicate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

