/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.client.ICrosshairRenderer;
import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.github.exopandora.shouldersurfing.mixins.GuiAccessor;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CrosshairRenderer
implements ICrosshairRenderer {
    private static final ResourceLocation OBSTRUCTION_INDICATOR_SPRITE = new ResourceLocation("shouldersurfing", "textures/gui/sprites/hud/obstruction_indicator.png");
    private static final ResourceLocation OBSTRUCTED_CROSSHAIR_SPRITE = new ResourceLocation("shouldersurfing", "textures/gui/sprites/hud/obstructed_crosshair.png");
    private static final ResourceLocation OBSTRUCTED_CROSSHAIR_CROSS_SPRITE = new ResourceLocation("shouldersurfing", "textures/gui/sprites/hud/obstructed_crosshair_cross.png");
    private final ShoulderSurfingImpl instance;
    private Vec2f crosshairOffset;

    public CrosshairRenderer(ShoulderSurfingImpl instance) {
        this.instance = instance;
        this.init();
    }

    private void init() {
        this.crosshairOffset = null;
    }

    public void preRenderCrosshair(PoseStack poseStack) {
        boolean isDynamic = this.isCrosshairDynamic(Minecraft.m_91087_().m_91288_());
        if (isDynamic || this.doRenderObstructionCrosshair()) {
            this.setupPoseStack(poseStack);
        }
    }

    public void postRenderCrosshair(PoseStack poseStack) {
        boolean doRenderObstructionCrosshair = this.doRenderObstructionCrosshair();
        boolean isDynamic = this.isCrosshairDynamic(Minecraft.m_91087_().m_91288_());
        if (isDynamic || doRenderObstructionCrosshair) {
            this.resetPoseStack(poseStack);
        }
        if (doRenderObstructionCrosshair) {
            this.renderObstructionCrosshair(poseStack);
        } else if (this.doRenderObstructionIndicator()) {
            this.setupPoseStack(poseStack);
            this.renderObstructionIndicator(poseStack);
            this.resetPoseStack(poseStack);
        }
    }

    private void setupPoseStack(PoseStack poseStack) {
        if (this.crosshairOffset != null) {
            poseStack.m_85836_();
            poseStack.m_85850_().m_85861_().m_27648_(new Vector3f(this.crosshairOffset.x(), -this.crosshairOffset.y(), 0.0f));
        }
    }

    private void resetPoseStack(PoseStack poseStack) {
        if (this.crosshairOffset != null) {
            poseStack.m_85849_();
        }
    }

    @Override
    public boolean doRenderCrosshair() {
        return Config.CLIENT.getCrosshairVisibility(Perspective.current()).doRender(Minecraft.m_91087_().f_91077_, this.instance.isAiming()) && (this.crosshairOffset != null || !this.isCrosshairDynamic(Minecraft.m_91087_().m_91288_()));
    }

    @Override
    public boolean doRenderObstructionCrosshair() {
        return this.doRenderObstructionIndicator() && this.instance.isAiming();
    }

    @Override
    public boolean doRenderObstructionIndicator() {
        int minDistanceToCrosshair = Config.CLIENT.getObstructionIndicatorMinDistanceToCrosshair();
        return this.crosshairOffset != null && this.instance.isShoulderSurfing() && Config.CLIENT.getShowObstructionCrosshair() && (this.instance.isAiming() || !Config.CLIENT.showObstructionIndicatorWhenAiming()) && !this.isCrosshairDynamic(Minecraft.m_91087_().m_91288_()) && this.crosshairOffset.lengthSquared() >= (double)(minDistanceToCrosshair * minDistanceToCrosshair);
    }

    public void updateDynamicRaytrace(Camera camera, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float partialTick) {
        if (this.instance.isShoulderSurfing() && Minecraft.m_91087_().f_91074_ != null) {
            boolean isDynamic = this.isCrosshairDynamic(Minecraft.m_91087_().m_91288_());
            double interactionRangeOverride = Config.CLIENT.useCustomRaytraceDistance() ? Config.CLIENT.getCustomRaytraceDistance() : 0.0;
            MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            PickContext.Builder pickContextBuilder = new PickContext.Builder(camera);
            if (isDynamic) {
                pickContextBuilder.dynamicTrace();
            }
            PickContext pickContext = pickContextBuilder.build();
            HitResult hitResult = this.instance.getObjectPicker().pick(pickContext, interactionRangeOverride, partialTick, gameMode);
            Vec3 position = hitResult.m_82450_();
            if (!isDynamic) {
                pickContext = pickContextBuilder.obstructionTrace(position).build();
                hitResult = this.instance.getObjectPicker().pick(pickContext, interactionRangeOverride, partialTick, gameMode);
                position = hitResult.m_82450_();
            }
            Vec2f projected = CrosshairRenderer.project2D(position.m_82546_(camera.m_90583_()), modelViewMatrix, projectionMatrix);
            Vec2f crosshairOffset = null;
            if (projected != null) {
                Window window = Minecraft.m_91087_().m_91268_();
                Vec2f screenSize = new Vec2f(window.m_85443_(), window.m_85444_());
                Vec2f center = screenSize.divide(2.0f);
                double maxDistanceToObstruction = Config.CLIENT.getObstructionIndicatorMaxDistanceToObstruction();
                if (isDynamic || !Config.CLIENT.getShowObstructionCrosshair() || maxDistanceToObstruction <= 0.0 || position.m_82557_(player.m_146892_()) <= maxDistanceToObstruction * maxDistanceToObstruction) {
                    crosshairOffset = projected.subtract(center).divide((float)window.m_85449_());
                }
            }
            this.crosshairOffset = crosshairOffset;
        }
    }

    @Override
    public boolean isCrosshairDynamic(Entity entity) {
        return this.instance.isShoulderSurfing() && Config.CLIENT.getCrosshairType().isDynamic(entity, this.instance.isAiming());
    }

    private void renderObstructionCrosshair(PoseStack poseStack) {
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.renderCustomCrosshair(poseStack, OBSTRUCTED_CROSSHAIR_SPRITE);
        RenderSystem.m_69453_();
        this.renderCustomCrosshair(poseStack, OBSTRUCTED_CROSSHAIR_CROSS_SPRITE);
    }

    private void renderObstructionIndicator(PoseStack poseStack) {
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.renderCustomCrosshair(poseStack, OBSTRUCTION_INDICATOR_SPRITE);
        RenderSystem.m_69453_();
    }

    private void renderCustomCrosshair(PoseStack poseStack, ResourceLocation sprite) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91072_.m_105295_() != GameType.SPECTATOR || ((GuiAccessor)minecraft.f_91065_).invokeCanRenderCrosshairForSpectator(minecraft.f_91077_)) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)sprite);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)((minecraft.m_91268_().m_85445_() - 15) / 2), (int)((minecraft.m_91268_().m_85446_() - 15) / 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (int)15, (int)15);
        }
    }

    public void resetState() {
        this.init();
    }

    @Nullable
    private static Vec2f project2D(Vec3 position, Matrix4f modelView, Matrix4f projection) {
        Window window = Minecraft.m_91087_().m_91268_();
        int screenWidth = window.m_85443_();
        int screenHeight = window.m_85444_();
        if (screenWidth == 0 || screenHeight == 0) {
            return null;
        }
        Vector4f vec = new Vector4f((float)position.m_7096_(), (float)position.m_7098_(), (float)position.m_7094_(), 1.0f);
        vec.m_123607_(modelView);
        vec.m_123607_(projection);
        if (vec.m_123617_() == 0.0f) {
            return null;
        }
        float w = 1.0f / vec.m_123617_() * 0.5f;
        float x = (vec.m_123601_() * w + 0.5f) * (float)screenWidth;
        float y = (vec.m_123615_() * w + 0.5f) * (float)screenHeight;
        float z = vec.m_123616_() * w + 0.5f;
        vec.m_123602_(x, y, z, w);
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isNaN(x) || Float.isNaN(y) || w < 0.0f) {
            return null;
        }
        return new Vec2f(x, y);
    }
}

