/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.forge.compat.plugin;

import com.github.exopandora.shouldersurfing.compat.plugin.ICuriosAdaptiveItemCallback;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.plugin.callbacks.AdaptiveItemCallback;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosAdaptiveItemCallback
implements ICuriosAdaptiveItemCallback {
    @Override
    public boolean isHoldingAdaptiveItem(Minecraft minecraft, LivingEntity entity) {
        LazyOptional lazyOptionalInventory = CuriosApi.getCuriosHelper().getCuriosHandler(entity);
        if (!lazyOptionalInventory.isPresent()) {
            return false;
        }
        Optional optionalInventory = lazyOptionalInventory.resolve();
        if (optionalInventory.isEmpty()) {
            return false;
        }
        ICuriosItemHandler inventory = (ICuriosItemHandler)optionalInventory.get();
        Map<String, List<String>> slotToItems = CuriosAdaptiveItemCallback.parseSlots(Config.CLIENT.getCuriosAdaptiveCrosshairItems());
        Map<String, List<String>> slotToItemProperties = CuriosAdaptiveItemCallback.parseSlots(Config.CLIENT.getCuriosAdaptiveCrosshairItemProperties());
        for (Map.Entry entry : inventory.getCurios().entrySet()) {
            List items = slotToItems.getOrDefault(entry.getKey(), Collections.emptyList());
            List itemProperties = slotToItemProperties.getOrDefault(entry.getKey(), Collections.emptyList());
            if (items.isEmpty() && itemProperties.isEmpty()) continue;
            IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
            for (int x = 0; x < stackHandler.getSlots(); ++x) {
                ItemStack stack = stackHandler.getStackInSlot(x);
                if (!AdaptiveItemCallback.isAdaptiveItemStack(stack.m_41720_(), items, itemProperties)) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<String, List<String>> parseSlots(List<? extends String> list) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String string : list) {
            String[] split = string.split("@", 2);
            result.computeIfAbsent(split[0], key -> new LinkedList()).add(split[1]);
        }
        return result;
    }
}

