/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.mixins;

import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.github.exopandora.shouldersurfing.mixinducks.CameraDuck;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class MixinCamera
implements CameraDuck {
    @Shadow
    private float f_90557_;
    @Shadow
    private float f_90558_;
    @Unique
    private float zRot;
    @Shadow
    @Final
    private Quaternion f_90559_;

    @Shadow
    protected abstract void m_90568_(double var1, double var3, double var5);

    @Shadow
    protected abstract void m_90572_(float var1, float var2);

    @Inject(method={"setup"}, at={@At(value="HEAD")})
    private void setupRotations(CallbackInfo ci) {
        this.shouldersurfing$setZRot(0.0f);
    }

    @Inject(method={"setup"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setPosition(DDD)V", shift=At.Shift.AFTER, ordinal=0)})
    private void setupRotations(BlockGetter level, Entity cameraEntity, boolean detached, boolean isMirrored, float partialTick, CallbackInfo ci) {
        LivingEntity livingEntity;
        if (!(Perspective.SHOULDER_SURFING != Perspective.current() || cameraEntity instanceof LivingEntity && (livingEntity = (LivingEntity)cameraEntity).m_5803_())) {
            ShoulderSurfingCamera camera = ShoulderSurfingImpl.getInstance().getCamera();
            Vec2f rotations = camera.calcRotations(cameraEntity, partialTick);
            this.m_90572_(rotations.y(), rotations.x());
        }
    }

    @Redirect(method={"setup"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;move(DDD)V", ordinal=0))
    private void setupPosition(Camera cameraIn, double x, double y, double z, BlockGetter level, Entity cameraEntity, boolean detached, boolean isMirrored, float partialTick) {
        LivingEntity livingEntity;
        if (!(Perspective.SHOULDER_SURFING != Perspective.current() || cameraEntity instanceof LivingEntity && (livingEntity = (LivingEntity)cameraEntity).m_5803_())) {
            ShoulderSurfingCamera camera = ShoulderSurfingImpl.getInstance().getCamera();
            Vec3 cameraOffset = camera.calcOffset(cameraIn, level, partialTick, cameraEntity);
            this.m_90568_(-cameraOffset.m_7094_(), cameraOffset.m_7098_(), cameraOffset.m_7096_());
            Vec2f sway = camera.calcSway(camera, cameraEntity, partialTick);
            this.zRot = sway.y();
            this.m_90572_(this.f_90558_, this.f_90557_ + sway.x());
        } else {
            this.m_90568_(x, y, z);
        }
    }

    @Inject(method={"setRotation(FF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/math/Quaternion;mul(Lcom/mojang/math/Quaternion;)V", shift=At.Shift.AFTER, ordinal=0)})
    private void setRotation(CallbackInfo ci) {
        this.f_90559_.m_80148_(Vector3f.f_122227_.m_122240_(this.shouldersurfing$getZRot()));
    }

    @Override
    public float shouldersurfing$getZRot() {
        return this.zRot;
    }

    @Override
    public void shouldersurfing$setZRot(float zRot) {
        this.zRot = zRot;
    }
}

