/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.callback.ITargetCameraOffsetCallback;
import com.github.exopandora.shouldersurfing.api.client.IShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.api.util.EntityHelper;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.github.exopandora.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ShoulderSurfingCamera
implements IShoulderSurfingCamera {
    private static final Vector3f VECTOR_NEGATIVE_Y = new Vector3f(0.0f, -1.0f, 0.0f);
    private final ShoulderSurfingImpl instance;
    private Vec3 offset;
    private Vec3 offsetO;
    private Vec3 renderOffset;
    private Vec3 targetOffset;
    private Vec3 deltaMovementO;
    private double cameraDistance;
    private double maxCameraDistance;
    private double maxCameraDistanceO;
    private float xRot;
    private float yRot;
    private float xRotOffset;
    private float yRotOffset;
    private float xRotOffsetO;
    private float yRotOffsetO;
    private float freeLookYRot;
    private float lastMovedYRot;
    private boolean initialized;

    public ShoulderSurfingCamera(ShoulderSurfingImpl instance) {
        this.instance = instance;
        this.init();
    }

    public void tick() {
        Entity entity;
        if (!this.initialized) {
            this.init();
        }
        double cameraTransitionSpeedMultiplier = Config.CLIENT.getCameraTransitionSpeedMultiplier();
        this.xRotOffsetO = this.xRotOffset;
        this.yRotOffsetO = this.yRotOffset;
        this.offsetO = this.offset;
        this.offset = this.offsetO.m_165921_(this.targetOffset, cameraTransitionSpeedMultiplier);
        this.maxCameraDistanceO = this.maxCameraDistance;
        this.maxCameraDistance += (this.offset.m_82553_() - this.maxCameraDistance) * cameraTransitionSpeedMultiplier;
        Entity cameraEntity = Minecraft.m_91087_().m_91288_();
        if (this.instance.isCameraDecoupled()) {
            if (EntityHelper.isPlayerSpectatingEntity() && cameraEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)cameraEntity;
                this.xRot += living.m_146909_() - living.f_19860_;
                this.yRot += living.m_6080_() - living.f_20886_;
            }
        } else if (cameraEntity != null && cameraEntity.m_20159_() && (entity = cameraEntity.m_20202_()) instanceof Boat) {
            Boat boat = (Boat)entity;
            this.yRot += boat.m_146908_() - boat.f_19859_;
        }
        if (cameraEntity != null) {
            this.deltaMovementO = ShoulderSurfingCamera.getDeltaMovementWithoutGravity(cameraEntity);
        }
        if (!this.instance.isFreeLooking()) {
            this.freeLookYRot = this.yRot;
            this.xRotOffset *= 0.5f;
            this.yRotOffset *= 0.5f;
        }
    }

    private void init() {
        this.offsetO = this.offset = new Vec3(Config.CLIENT.getOffsetX(), Config.CLIENT.getOffsetY(), Config.CLIENT.getOffsetZ());
        this.renderOffset = this.offset;
        this.targetOffset = this.offset;
        this.maxCameraDistanceO = this.maxCameraDistance = this.offset.m_82553_();
        Entity cameraEntity = Minecraft.m_91087_().m_91288_();
        if (cameraEntity != null) {
            this.xRot = cameraEntity.m_146909_();
            this.yRot = cameraEntity.m_146908_();
            this.deltaMovementO = ShoulderSurfingCamera.getDeltaMovementWithoutGravity(cameraEntity);
        } else {
            this.xRot = 0.0f;
            this.yRot = -180.0f;
            this.deltaMovementO = Vec3.f_82478_;
        }
        this.xRotOffset = 0.0f;
        this.yRotOffset = 0.0f;
        this.xRotOffsetO = 0.0f;
        this.yRotOffsetO = 0.0f;
        this.lastMovedYRot = this.yRot;
        this.initialized = true;
    }

    public Vec2f calcRotations(Entity cameraEntity, float partialTick) {
        Entity entity;
        if (!this.instance.isCameraDecoupled() && EntityHelper.isPlayerSpectatingEntity() && cameraEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)cameraEntity;
            return new Vec2f(living.m_5686_(partialTick), living.m_5675_(partialTick));
        }
        float cameraXRotWithOffset = Mth.m_14036_((float)(Mth.m_14189_((float)partialTick, (float)this.xRotOffsetO, (float)this.xRotOffset) + this.xRot), (float)-90.0f, (float)90.0f);
        float cameraYRotWithOffset = Mth.m_14189_((float)partialTick, (float)this.yRotOffsetO, (float)this.yRotOffset) + this.yRot;
        if (this.instance.isCameraDecoupled()) {
            if (EntityHelper.isPlayerSpectatingEntity() && cameraEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)cameraEntity;
                cameraXRotWithOffset += (living.m_146909_() - living.f_19860_) * partialTick;
                cameraYRotWithOffset += (living.m_6080_() - living.f_20886_) * partialTick;
            }
        } else if (cameraEntity != null && !this.instance.isCameraDecoupled() && cameraEntity.m_20159_() && (entity = cameraEntity.m_20202_()) instanceof Boat) {
            Boat boat = (Boat)entity;
            cameraYRotWithOffset += (boat.m_146908_() - boat.f_19859_) * partialTick;
        }
        return new Vec2f(cameraXRotWithOffset, cameraYRotWithOffset);
    }

    public Vec3 calcOffset(Camera camera, BlockGetter level, float partialTick, Entity cameraEntity) {
        LivingEntity living;
        Vec3 defaultOffset;
        Vec3 targetOffset = defaultOffset = new Vec3(Config.CLIENT.getOffsetX(), Config.CLIENT.getOffsetY(), Config.CLIENT.getOffsetZ());
        List<ITargetCameraOffsetCallback> targetCameraOffsetCallbacks = ShoulderSurfingRegistrar.getInstance().getTargetCameraOffsetCallbacks();
        for (ITargetCameraOffsetCallback targetCameraOffsetCallback : targetCameraOffsetCallbacks) {
            targetOffset = targetCameraOffsetCallback.pre(this.instance, targetOffset, defaultOffset);
        }
        if (cameraEntity.m_20159_()) {
            targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getPassengerOffsetModifiers(), Config.CLIENT.getPassengerOffsetMultipliers());
        }
        if (cameraEntity.m_20142_()) {
            targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getSprintOffsetModifiers(), Config.CLIENT.getSprintOffsetMultipliers());
        }
        if (this.instance.isAiming()) {
            targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getAimingOffsetModifiers(), Config.CLIENT.getAimingOffsetMultipliers());
        }
        if (cameraEntity instanceof LivingEntity && (living = (LivingEntity)cameraEntity).m_21255_()) {
            targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getFallFlyingOffsetModifiers(), Config.CLIENT.getFallFlyingMultipliers());
        }
        if (!cameraEntity.m_5833_()) {
            if (cameraEntity instanceof LivingEntity && (living = (LivingEntity)cameraEntity).m_6147_()) {
                targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getClimbingOffsetModifiers(), Config.CLIENT.getClimbingMultipliers());
            }
            if (ShoulderSurfingCamera.angle(camera.m_90596_(), VECTOR_NEGATIVE_Y) < Config.CLIENT.getCenterCameraWhenLookingDownAngle() * 0.01745329238474369) {
                targetOffset = new Vec3(0.0, 0.0, targetOffset.m_7094_());
            }
            if (Config.CLIENT.doDynamicallyAdjustOffsets()) {
                targetOffset = ShoulderSurfingCamera.calcDynamicOffsets(camera, cameraEntity, level, targetOffset);
            }
        }
        double targetOffsetX = Config.CLIENT.isUnlimitedOffsetX() ? targetOffset.m_7096_() : Mth.m_14008_((double)targetOffset.m_7096_(), (double)Config.CLIENT.getMinOffsetX(), (double)Config.CLIENT.getMaxOffsetX());
        double targetOffsetY = Config.CLIENT.isUnlimitedOffsetY() ? targetOffset.m_7098_() : Mth.m_14008_((double)targetOffset.m_7098_(), (double)Config.CLIENT.getMinOffsetY(), (double)Config.CLIENT.getMaxOffsetY());
        double targetOffsetZ = Config.CLIENT.isUnlimitedOffsetZ() ? targetOffset.m_7094_() : Mth.m_14008_((double)targetOffset.m_7094_(), (double)Config.CLIENT.getMinOffsetZ(), (double)Config.CLIENT.getMaxOffsetZ());
        targetOffset = new Vec3(targetOffsetX, targetOffsetY, targetOffsetZ);
        for (ITargetCameraOffsetCallback targetCameraOffsetCallback : targetCameraOffsetCallbacks) {
            targetOffset = targetCameraOffsetCallback.post(this.instance, targetOffset, defaultOffset);
        }
        this.targetOffset = targetOffset;
        Vec3 drag = this.calcCameraDrag(camera, cameraEntity, partialTick);
        Vec3 lerpedOffset = this.offsetO.m_165921_(this.offset, (double)partialTick).m_82549_(drag);
        if (cameraEntity.m_5833_()) {
            this.cameraDistance = lerpedOffset.m_82553_();
            this.renderOffset = lerpedOffset;
        } else {
            double targetCameraDistance = ShoulderSurfingCamera.maxZoom(camera, level, lerpedOffset, partialTick);
            if (targetCameraDistance < this.maxCameraDistance) {
                this.maxCameraDistance = targetCameraDistance;
            }
            double lerpedMaxDistance = Mth.m_14139_((double)partialTick, (double)this.maxCameraDistanceO, (double)this.maxCameraDistance);
            this.cameraDistance = Math.min(targetCameraDistance, lerpedMaxDistance);
            this.renderOffset = lerpedOffset.m_82541_().m_82490_(this.cameraDistance);
        }
        return this.renderOffset;
    }

    private static Vec3 applyModifiersAndMultipliers(Vec3 targetVec, Vec3 originalVec, Vec3 modifiers, Vec3 multipliers) {
        return targetVec.m_82549_(originalVec.m_82559_(multipliers).m_82546_(originalVec)).m_82549_(modifiers);
    }

    private static Vec3 calcDynamicOffsets(Camera camera, Entity cameraEntity, BlockGetter level, Vec3 targetOffset) {
        Vec3 lookVector = new Vec3(camera.m_90596_());
        Vec3 worldXYOffset = new Vec3(camera.m_90597_()).m_82490_(targetOffset.m_7098_()).m_82549_(new Vec3(camera.m_167686_()).m_82490_(targetOffset.m_7096_()));
        Vec3 worldOffset = worldXYOffset.m_82549_(lookVector.m_82490_(-targetOffset.m_7094_()));
        double offsetXAbs = Math.abs(targetOffset.m_7096_());
        double offsetYAbs = Math.abs(targetOffset.m_7098_());
        double offsetZAbs = Math.abs(targetOffset.m_7094_());
        double targetX = offsetXAbs;
        double targetY = offsetYAbs;
        double clearance = (double)cameraEntity.m_20205_() / 3.0;
        Vec3 cameraPosition = camera.m_90583_();
        for (double dz = 0.0; dz <= offsetZAbs; dz += 0.03125) {
            double newTargetY;
            Vec3 endPos;
            double scale = dz / offsetZAbs;
            Vec3 startPos = cameraPosition.m_82549_(worldOffset.m_82490_(scale));
            ClipContext context = new ClipContext(startPos, endPos = cameraPosition.m_82549_(worldXYOffset).m_82549_(lookVector.m_82490_(-dz)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, cameraEntity);
            BlockHitResult hitResult = level.m_45547_(context);
            if (hitResult.m_6662_() == HitResult.Type.MISS) continue;
            double distance = hitResult.m_82450_().m_82554_(startPos);
            double newTargetX = Math.max(distance + offsetXAbs * scale - clearance, 0.0);
            if (newTargetX < targetX) {
                targetX = newTargetX;
            }
            if (!((newTargetY = Math.max(distance + offsetYAbs * scale - clearance, 0.0)) < targetY)) continue;
            targetY = newTargetY;
        }
        double targetXOffset = Math.signum(targetOffset.m_7096_()) * targetX;
        double targetYOffset = Math.signum(targetOffset.m_7098_()) * targetY;
        return new Vec3(targetXOffset, targetYOffset, targetOffset.m_7094_());
    }

    private static double maxZoom(Camera camera, BlockGetter level, Vec3 cameraOffset, float partialTick) {
        double distance = cameraOffset.m_82553_();
        Vec3 worldOffset = new Vec3(camera.m_90597_()).m_82490_(cameraOffset.m_7098_()).m_82549_(new Vec3(camera.m_167686_()).m_82490_(cameraOffset.m_7096_())).m_82549_(new Vec3(camera.m_90596_()).m_82490_(-cameraOffset.m_7094_()));
        Vec3 eyePosition = camera.m_90592_().m_20299_(partialTick);
        for (int i = 0; i < 8; ++i) {
            double newDistance;
            Vec3 toOffset;
            Vec3 to;
            Vec3 offset = new Vec3((double)(i & 1), (double)(i >> 1 & 1), (double)(i >> 2 & 1)).m_82490_(2.0).m_82492_(1.0, 1.0, 1.0);
            Vec3 fromOffset = offset.m_82490_((double)Mth.m_14036_((float)(camera.m_90592_().m_20205_() / 2.0f / Mth.m_14116_((float)2.0f)), (float)0.0f, (float)0.15f)).m_82496_(-camera.m_90589_() * ((float)Math.PI / 180)).m_82524_(-camera.m_90590_() * ((float)Math.PI / 180));
            Vec3 from = eyePosition.m_82549_(fromOffset);
            ClipContext context = new ClipContext(from, to = eyePosition.m_82549_(toOffset = offset.m_82490_(0.15).m_82496_(-camera.m_90589_() * ((float)Math.PI / 180)).m_82524_(-camera.m_90590_() * ((float)Math.PI / 180))).m_82549_(worldOffset), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, camera.m_90592_());
            BlockHitResult hitResult = level.m_45547_(context);
            if (hitResult.m_6662_() == HitResult.Type.MISS || !((newDistance = hitResult.m_82450_().m_82554_(eyePosition)) < distance)) continue;
            distance = newDistance;
        }
        return distance;
    }

    private Vec3 calcCameraDrag(Camera cameraIn, Entity cameraEntity, float partialTick) {
        Vec3 deltaMovement = ShoulderSurfingCamera.getDeltaMovementWithoutGravity(cameraEntity);
        Vec3 deltaMovementLerped = this.deltaMovementO.m_165921_(deltaMovement, (double)partialTick).m_82559_(Config.CLIENT.getCameraDragMultipliers()).m_82524_(cameraIn.m_90590_() * ((float)Math.PI / 180)).m_82496_(cameraIn.m_90589_() * ((float)Math.PI / 180));
        return new Vec3(-deltaMovementLerped.f_82479_, -deltaMovementLerped.f_82480_, deltaMovementLerped.f_82481_);
    }

    public Vec2f calcSway(ShoulderSurfingCamera camera, Entity cameraEntity, float partialTick) {
        Vec3 deltaMovement = ShoulderSurfingCamera.getDeltaMovementWithoutGravity(cameraEntity);
        Vec3 deltaMovementLerped = this.deltaMovementO.m_165921_(deltaMovement, (double)partialTick).m_82524_(camera.getYRot() * ((float)Math.PI / 180)).m_82496_(camera.getXRot() * ((float)Math.PI / 180));
        double maxVelocityX = Config.CLIENT.getCameraSwayXMaxVelocity() / 20.0;
        double maxVelocityZ = Config.CLIENT.getCameraSwayZMaxVelocity() / 20.0;
        double maxAngleX = Config.CLIENT.getCameraSwayXMaxAngle();
        double maxAngleZ = Config.CLIENT.getCameraSwayZMaxAngle();
        double swayX = Math.min(Math.abs(deltaMovementLerped.f_82480_), maxVelocityX) / maxVelocityX * maxAngleX * Math.signum(deltaMovementLerped.f_82480_);
        double swayZ = Math.min(Math.abs(deltaMovementLerped.f_82479_), maxVelocityZ) / maxVelocityZ * maxAngleZ * Math.signum(deltaMovementLerped.f_82479_);
        return new Vec2f((float)swayX, (float)swayZ);
    }

    public boolean turn(LocalPlayer player, double yRot, double xRot) {
        if (this.instance.isShoulderSurfing()) {
            float scaledXRot = (float)(xRot * (double)0.15f);
            float scaledYRot = (float)(yRot * (double)0.15f);
            if (this.instance.isFreeLooking()) {
                this.xRotOffset = Mth.m_14036_((float)(this.xRotOffset + scaledXRot), (float)-90.0f, (float)90.0f);
                this.yRotOffset = Mth.m_14177_((float)(this.yRotOffset + scaledYRot));
                this.xRotOffsetO = this.xRotOffset;
                this.yRotOffsetO = this.yRotOffset;
                return true;
            }
            float cameraXRot = Mth.m_14036_((float)(this.xRot + scaledXRot), (float)-90.0f, (float)90.0f);
            float cameraYRot = this.yRot + scaledYRot;
            if (player.m_20159_()) {
                Vec2f constraintRotations = ShoulderSurfingCamera.applyPassengerRotationConstraints((Player)player, cameraXRot, cameraYRot, this.xRot, this.yRot);
                cameraXRot = constraintRotations.x();
                cameraYRot = constraintRotations.y();
            }
            if (this.instance.isCameraDecoupled()) {
                boolean isMoving;
                boolean bl = isMoving = player.f_108618_.f_108566_ != 0.0f || player.f_108618_.f_108567_ != 0.0f || player.m_21255_();
                if (this.instance.shouldEntityFollowCamera((LivingEntity)player)) {
                    player.m_146926_(cameraXRot);
                    player.m_146922_(cameraYRot);
                    player.f_19860_ += Mth.m_14118_((float)this.xRot, (float)cameraXRot);
                    player.f_19859_ += Mth.m_14118_((float)this.yRot, (float)cameraYRot);
                } else if (!this.instance.shouldEntityAimAtTarget((LivingEntity)player, Minecraft.m_91087_())) {
                    if (Config.CLIENT.shouldPlayerXRotFollowCamera()) {
                        player.m_146926_(cameraXRot);
                        player.f_19860_ += Mth.m_14118_((float)this.xRot, (float)cameraXRot);
                    }
                    if (Config.CLIENT.shouldPlayerYRotFollowCamera() && !isMoving) {
                        float maxFollowAngle = (float)Config.CLIENT.getPlayerYRotFollowAngleLimit();
                        float playerYRot = Mth.m_14148_((float)this.lastMovedYRot, (float)(player.m_146908_() + scaledYRot), (float)maxFollowAngle);
                        player.f_19859_ = player.m_146908_();
                        player.m_146922_(playerYRot);
                    }
                }
                if (isMoving) {
                    this.lastMovedYRot = player.m_146908_();
                }
            }
            this.xRot = cameraXRot;
            this.yRot = cameraYRot;
            return this.instance.isCameraDecoupled();
        }
        return false;
    }

    private static Vec2f applyPassengerRotationConstraints(Player player, float cameraXRot, float cameraYRot, float cameraXRotO, float cameraYRotO) {
        Entity vehicle = player.m_20202_();
        float partialTick = Minecraft.m_91087_().m_91296_();
        float playerXRot = player.m_146909_();
        float playerYRot = player.m_146908_();
        float playerXRotO = player.f_19860_;
        float playerYRotO = player.f_19859_;
        float playerYHeadRot = player.f_20885_;
        float playerYHeadRotO = player.f_20886_;
        float playerYBodyRot = player.f_20883_;
        float playerYBodyRotO = player.f_20884_;
        float vehicleXRot = vehicle.m_146909_();
        float vehicleYRot = vehicle.m_146908_();
        float vehicleXRotO = vehicle.f_19860_;
        float vehicleYRotO = vehicle.f_19859_;
        vehicle.m_146926_(Mth.m_14189_((float)partialTick, (float)vehicleXRotO, (float)vehicleXRot));
        vehicle.m_146922_(Mth.m_14189_((float)partialTick, (float)vehicleYRotO, (float)vehicleYRot));
        player.m_146926_(cameraXRot);
        player.m_146922_(cameraYRot);
        player.f_19860_ = cameraXRotO;
        player.f_19859_ = cameraYRotO;
        player.f_20885_ = cameraYRot;
        player.f_20886_ = cameraYRotO;
        player.f_20883_ = cameraYRot;
        player.f_20884_ = cameraYRotO;
        vehicle.m_7340_((Entity)player);
        if (player.m_146909_() != cameraXRot) {
            cameraXRot = player.m_146909_();
        }
        if (player.m_146908_() != cameraYRot) {
            cameraYRot = player.m_146908_();
        }
        player.m_146926_(playerXRot);
        player.m_146922_(playerYRot);
        player.f_19860_ = playerXRotO;
        player.f_19859_ = playerYRotO;
        player.f_20885_ = playerYHeadRot;
        player.f_20886_ = playerYHeadRotO;
        player.f_20883_ = playerYBodyRot;
        player.f_20884_ = playerYBodyRotO;
        vehicle.m_146926_(vehicleXRot);
        vehicle.m_146922_(vehicleYRot);
        return new Vec2f(cameraXRot, cameraYRot);
    }

    public void resetState() {
        this.initialized = false;
    }

    @Override
    public double getCameraDistance() {
        return this.cameraDistance;
    }

    @Override
    public Vec3 getOffset() {
        return this.offset;
    }

    @Override
    public Vec3 getRenderOffset() {
        return this.renderOffset;
    }

    @Override
    public Vec3 getTargetOffset() {
        return this.targetOffset;
    }

    @Override
    public float getXRot() {
        return this.xRot + this.xRotOffset;
    }

    @Override
    public void setXRot(float xRot) {
        this.xRot = xRot;
        this.xRotOffset = 0.0f;
        this.xRotOffsetO = 0.0f;
    }

    @Override
    public float getYRot() {
        return this.yRot + this.yRotOffset;
    }

    @Override
    public void setYRot(float yRot) {
        this.yRot = yRot;
        this.yRotOffset = 0.0f;
        this.yRotOffsetO = 0.0f;
    }

    public float getFreeLookYRot() {
        return this.freeLookYRot;
    }

    public void setLastMovedYRot(float lastMovedYRot) {
        this.lastMovedYRot = lastMovedYRot;
    }

    private static Vec3 getDeltaMovementWithoutGravity(Entity entity) {
        LivingEntity living;
        Vec3 deltaMovement = entity.m_20184_();
        double friction = 0.98;
        double gravity = 0.08;
        if (deltaMovement.f_82480_ <= 0.0 && entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_(MobEffects.f_19591_)) {
            gravity = 0.01;
        }
        return deltaMovement.m_82520_(0.0, gravity * 0.98, 0.0);
    }

    public static double length(Vector3f vec) {
        return Mth.m_14116_((float)(vec.m_122239_() * vec.m_122239_() + vec.m_122260_() * vec.m_122260_() + vec.m_122269_() * vec.m_122269_()));
    }

    public static double angle(Vector3f a, Vector3f b) {
        return Math.acos((double)a.m_122276_(b) / (ShoulderSurfingCamera.length(a) * ShoulderSurfingCamera.length(b)));
    }
}

