/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.forge.compat;

import com.github.exopandora.shouldersurfing.compat.Mods;
import com.github.exopandora.shouldersurfing.compat.ShoulderSurfingCompatMixinPlugin;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ShoulderSurfingCompatMixinPluginForge
extends ShoulderSurfingCompatMixinPlugin {
    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        ShoulderSurfingCompatMixinPluginForge.addCommonCompatMixins(mixins);
        ShoulderSurfingCompatMixinPluginForge.addMtsMixins(mixins);
        ShoulderSurfingCompatMixinPluginForge.addSkinLayersMixins(mixins);
        return mixins.isEmpty() ? null : mixins;
    }

    private static void addMtsMixins(List<String> mixins) {
        if (Mods.MTS.isLoaded()) {
            mixins.add("mts.MixinCameraSystem");
        }
    }

    private static void addSkinLayersMixins(List<String> mixins) {
        String skinLayersModVersion = Mods.SKIN_LAYERS.getModVersion();
        if (skinLayersModVersion != null) {
            DefaultArtifactVersion version = new DefaultArtifactVersion(skinLayersModVersion);
            if (ShoulderSurfingCompatMixinPluginForge.parseVersionRangeSilent("[1_6_6,)").containsVersion((ArtifactVersion)version)) {
                mixins.add("skinlayers.MixinCustomizableModelPart_1_6_6");
            } else if (ShoulderSurfingCompatMixinPluginForge.parseVersionRangeSilent("(,1.6.6)").containsVersion((ArtifactVersion)version)) {
                mixins.add("skinlayers.MixinCustomizableModelPart_1_6_5");
            }
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static VersionRange parseVersionRangeSilent(String predicate) {
        try {
            return VersionRange.createFromVersionSpec((String)predicate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

