/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.mixins;

import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.client.SoundHelper;
import com.github.exopandora.shouldersurfing.config.Config;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientLevel
extends Level {
    @Shadow
    @Final
    private Minecraft f_104565_;

    protected MixinClientLevel(WritableLevelData levelData, ResourceKey<Level> dimension, Holder<DimensionType> dimensionTypeRegistration, Supplier<ProfilerFiller> profiler, boolean isClientSide, boolean isDebug, long seed) {
        super(levelData, dimension, dimensionTypeRegistration, profiler, isClientSide, isDebug, seed);
    }

    @Overwrite
    public void m_7785_(double x, double y, double z, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, boolean isDelayed) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && ShoulderSurfingImpl.getInstance().isShoulderSurfing() && Config.CLIENT.doCenterPlayerSounds() && (x == player.m_20185_() && y == player.m_20186_() && z == player.m_20189_() || MixinClientLevel.round(player.f_19854_) == x && MixinClientLevel.round(player.f_19855_) == y && MixinClientLevel.round(player.f_19856_) == z)) {
            Vec3 pos = SoundHelper.calcCameraCentricSoundPosition((Entity)player);
            x = pos.m_7096_();
            y = pos.m_7098_();
            z = pos.m_7094_();
        }
        double distanceSq = this.f_104565_.f_91063_.m_109153_().m_90583_().m_82531_(x, y, z);
        SimpleSoundInstance simplesoundinstance = new SimpleSoundInstance(soundEvent, soundSource, volume, pitch, x, y, z);
        if (isDelayed && distanceSq > 100.0) {
            double distance = Math.sqrt(distanceSq) / 40.0;
            this.f_104565_.m_91106_().m_120369_((SoundInstance)simplesoundinstance, (int)(distance * 20.0));
        } else {
            this.f_104565_.m_91106_().m_120367_((SoundInstance)simplesoundinstance);
        }
    }

    @Unique
    private static double round(double d) {
        return (float)((int)(d * 8.0)) / 8.0f;
    }
}

