/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.mixins;

import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class MixinClientPacketListener {
    @Shadow
    @Final
    private Minecraft f_104888_;

    @Inject(at={@At(value="TAIL")}, method={"handleLogin"})
    private void handleLogin(CallbackInfo ci) {
        ShoulderSurfingImpl.getInstance().resetState();
    }

    @Inject(at={@At(value="HEAD")}, method={"handleRespawn"})
    private void handleRespawn(ClientboundRespawnPacket packet, CallbackInfo ci) {
        if (!packet.m_132961_()) {
            ShoulderSurfingImpl.getInstance().resetState();
        }
    }

    @Inject(method={"handleMovePlayer"}, at={@At(value="INVOKE", target="net/minecraft/network/protocol/PacketUtils.ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)})
    private void handleMovePlayer(ClientboundPlayerPositionPacket packet, CallbackInfo ci) {
        ShoulderSurfingImpl instance = ShoulderSurfingImpl.getInstance();
        if (instance.isShoulderSurfing() && Config.CLIENT.doOrientCameraOnTeleport()) {
            ShoulderSurfingCamera camera;
            LocalPlayer player = this.f_104888_.f_91074_;
            boolean isRelativeXRot = packet.m_132826_().contains(ClientboundPlayerPositionPacket.RelativeArgument.X_ROT);
            boolean isRelativeYRot = packet.m_132826_().contains(ClientboundPlayerPositionPacket.RelativeArgument.Y_ROT);
            if (isRelativeXRot && packet.m_132824_() != 0.0f || !isRelativeXRot && player.m_146909_() != packet.m_132824_()) {
                camera = instance.getCamera();
                camera.setXRot(isRelativeXRot ? camera.getXRot() + packet.m_132824_() : packet.m_132824_());
            }
            if (isRelativeYRot && packet.m_132823_() != 0.0f || !isRelativeYRot && player.m_146908_() != packet.m_132823_()) {
                camera = instance.getCamera();
                camera.setYRot(isRelativeYRot ? camera.getYRot() + packet.m_132823_() : packet.m_132823_());
            }
        }
    }
}

