/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.client.ICameraEntityRenderer;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class CameraEntityRenderer
implements ICameraEntityRenderer {
    private final ShoulderSurfingImpl instance;
    private float cameraEntityAlpha = 1.0f;
    private boolean isRenderingCameraEntity;

    public CameraEntityRenderer(ShoulderSurfingImpl instance) {
        this.instance = instance;
    }

    public boolean preRenderCameraEntity(Entity entity, float partialTick) {
        if (this.shouldSkipCameraEntityRendering(entity)) {
            return true;
        }
        this.isRenderingCameraEntity = true;
        if (this.shouldRenderCameraEntityTransparent(entity)) {
            Vec3 renderOffset = this.instance.getCamera().getRenderOffset();
            float xAlpha = (float)Mth.clamp((double)(Math.abs(renderOffset.x()) / ((double)entity.getBbWidth() / 2.0)), (double)0.0, (double)1.0);
            float yAlpha = 0.0f;
            if (renderOffset.y() > 0.0) {
                yAlpha = (float)Mth.clamp((double)(renderOffset.y() / (double)(entity.getBbHeight() - entity.getEyeHeight())), (double)0.0, (double)1.0);
            } else if (renderOffset.y() < 0.0) {
                yAlpha = (float)Mth.clamp((double)(-renderOffset.y() / (double)(-entity.getEyeHeight())), (double)0.0, (double)1.0);
            }
            this.cameraEntityAlpha = Mth.clamp((float)((float)Math.sqrt(xAlpha * xAlpha + yAlpha * yAlpha)), (float)0.15f, (float)1.0f);
        } else {
            this.cameraEntityAlpha = 1.0f;
        }
        return false;
    }

    public void postRenderCameraEntity(Entity entity, float partialTick) {
        this.isRenderingCameraEntity = false;
    }

    private boolean shouldSkipCameraEntityRendering(Entity cameraEntity) {
        Player player;
        ShoulderSurfingCamera camera = this.instance.getCamera();
        return this.instance.isShoulderSurfing() && !cameraEntity.isSpectator() && (camera.getCameraDistance() < (double)cameraEntity.getBbWidth() * Config.CLIENT.keepCameraOutOfHeadMultiplier() || (double)camera.getXRot() < Config.CLIENT.getHidePlayerWhenLookingUpAngle() - 90.0 || cameraEntity instanceof Player && (player = (Player)cameraEntity).isScoping());
    }

    private boolean shouldRenderCameraEntityTransparent(Entity entity) {
        Vec3 renderOffset = this.instance.getCamera().getRenderOffset();
        return this.instance.isShoulderSurfing() && Config.CLIENT.isPlayerTransparencyEnabled() && !entity.isSpectator() && Math.abs(renderOffset.x()) < (double)entity.getBbWidth() / 2.0 && (renderOffset.y() >= 0.0 && renderOffset.y() < (double)(entity.getBbHeight() - entity.getEyeHeight()) || renderOffset.y() <= 0.0 && -renderOffset.y() < (double)entity.getEyeHeight());
    }

    public int applyCameraEntityAlphaContextAware(int color) {
        return this.isRenderingCameraEntity ? this.applyCameraEntityAlpha(color) : color;
    }

    public int applyCameraEntityAlpha(int color) {
        int alpha;
        int cameraEntityAlpha = this.getCameraEntityAlphaAsInt();
        if (cameraEntityAlpha < (alpha = ARGB.alpha((int)color))) {
            return ARGB.transparent((int)color) + (cameraEntityAlpha << 24);
        }
        return color;
    }

    @Override
    public boolean isRenderingCameraEntity() {
        return this.isRenderingCameraEntity;
    }

    @Override
    public float getCameraEntityAlpha() {
        return this.cameraEntityAlpha;
    }

    @Override
    public int getCameraEntityAlphaAsInt() {
        return ARGB.as8BitChannel((float)this.cameraEntityAlpha);
    }
}

