/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.mixins;

import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.world.entity.Relative;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class MixinClientPacketListener
extends ClientCommonPacketListenerImpl {
    protected MixinClientPacketListener(Minecraft minecraft, Connection connection, CommonListenerCookie commonListenerCookie) {
        super(minecraft, connection, commonListenerCookie);
    }

    @Inject(at={@At(value="TAIL")}, method={"handleLogin"})
    private void handleLogin(CallbackInfo ci) {
        ShoulderSurfingImpl.getInstance().resetState();
    }

    @Inject(at={@At(value="HEAD")}, method={"handleRespawn"})
    private void handleRespawn(ClientboundRespawnPacket packet, CallbackInfo ci) {
        if (!packet.shouldKeep((byte)3)) {
            ShoulderSurfingImpl.getInstance().resetState();
        }
    }

    @Inject(method={"handleMovePlayer"}, at={@At(value="INVOKE", target="net/minecraft/network/protocol/PacketUtils.ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)})
    private void handleMovePlayer(ClientboundPlayerPositionPacket packet, CallbackInfo ci) {
        ShoulderSurfingImpl instance = ShoulderSurfingImpl.getInstance();
        if (instance.isShoulderSurfing() && Config.CLIENT.doOrientCameraOnTeleport()) {
            ShoulderSurfingCamera camera;
            LocalPlayer player = this.minecraft.player;
            boolean isRelativeXRot = packet.relatives().contains(Relative.X_ROT);
            boolean isRelativeYRot = packet.relatives().contains(Relative.Y_ROT);
            if (isRelativeXRot && packet.change().xRot() != 0.0f || !isRelativeXRot && player.getXRot() != packet.change().xRot()) {
                camera = instance.getCamera();
                camera.setXRot(isRelativeXRot ? camera.getXRot() + packet.change().xRot() : packet.change().xRot());
            }
            if (isRelativeYRot && packet.change().yRot() != 0.0f || !isRelativeYRot && player.getYRot() != packet.change().yRot()) {
                camera = instance.getCamera();
                camera.setYRot(isRelativeYRot ? camera.getYRot() + packet.change().yRot() : packet.change().yRot());
            }
        }
    }
}

