/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.plugin;

import com.github.exopandora.shouldersurfing.ShoulderSurfingCommon;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingPlugin;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingRegistrar;
import com.github.exopandora.shouldersurfing.compat.Mods;
import com.github.exopandora.shouldersurfing.compat.plugin.CreateModTargetCameraOffsetCallback;
import com.github.exopandora.shouldersurfing.config.Config;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ShoulderSurfingPlugin
implements IShoulderSurfingPlugin {
    @Override
    public void register(IShoulderSurfingRegistrar registrar) {
        registrar.registerAdaptiveItemCallback(ShoulderSurfingPlugin::isHoldingAdaptiveItem);
        if (Mods.CREATE.isLoaded()) {
            try {
                ShoulderSurfingCommon.LOGGER.info("Registering compatibility callback for create mod");
                registrar.registerTargetCameraOffsetCallback(new CreateModTargetCameraOffsetCallback());
            }
            catch (Throwable t) {
                ShoulderSurfingCommon.LOGGER.error("Failed to load compatibility callback for create mod", t);
            }
        }
    }

    private static boolean isHoldingAdaptiveItem(Minecraft minecraft, LivingEntity entity) {
        ItemStack[] handItems;
        ItemStack useStack = entity.getUseItem();
        List<? extends String> useItems = Config.CLIENT.getAdaptiveCrosshairUseItems();
        String useItemId = BuiltInRegistries.ITEM.getKey((Object)useStack.getItem()).toString();
        if (useItems.stream().map(ShoulderSurfingPlugin::expressionToMatchPredicate).anyMatch(pattern -> pattern.test(useItemId))) {
            return true;
        }
        if (!useStack.getComponentsPatch().isEmpty()) {
            DataComponentPatch patch = useStack.getComponentsPatch();
            for (String string : Config.CLIENT.getAdaptiveCrosshairUseItemComponents()) {
                Optional component;
                Optional type = BuiltInRegistries.DATA_COMPONENT_TYPE.getOptional(ResourceLocation.tryParse((String)string));
                if (type.isEmpty() || (component = patch.get((DataComponentType)type.get())) == null || !component.isPresent()) continue;
                return true;
            }
        }
        String useAnimation = useStack.getUseAnimation().getSerializedName();
        for (String string : Config.CLIENT.getAdaptiveCrosshairUseItemAnimations()) {
            if (!string.equals(useAnimation)) continue;
            return true;
        }
        List<? extends String> holdItems = Config.CLIENT.getAdaptiveCrosshairHoldItems();
        List<? extends String> list = Config.CLIENT.getAdaptiveCrosshairHoldItemAnimations();
        for (ItemStack handStack : handItems = new ItemStack[]{entity.getMainHandItem(), entity.getOffhandItem()}) {
            String handItemId = BuiltInRegistries.ITEM.getKey((Object)handStack.getItem()).toString();
            if (holdItems.stream().map(ShoulderSurfingPlugin::expressionToMatchPredicate).anyMatch(pattern -> pattern.test(handItemId))) {
                return true;
            }
            if (!handStack.getComponentsPatch().isEmpty()) {
                DataComponentPatch patch = handStack.getComponentsPatch();
                for (String string : Config.CLIENT.getAdaptiveCrosshairHoldItemComponents()) {
                    Optional component;
                    Optional type = BuiltInRegistries.DATA_COMPONENT_TYPE.getOptional(ResourceLocation.tryParse((String)string));
                    if (type.isEmpty() || (component = patch.get((DataComponentType)type.get())) == null || !component.isPresent()) continue;
                    return true;
                }
            }
            String handItemUseAnimation = handStack.getUseAnimation().getSerializedName();
            for (String string : list) {
                if (!handItemUseAnimation.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private static Predicate<String> expressionToMatchPredicate(String expression) {
        try {
            return Pattern.compile(expression).asMatchPredicate();
        }
        catch (Exception e) {
            return expression::equals;
        }
    }
}

